/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.opendaylight.controller.hosttracker.IHostId;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.hosttracker.internal.HostTracker;

public class HostTrackerCallable
implements Callable<HostNodeConnector> {
    IHostId trackedHost;
    HostTracker hostTracker;
    protected CountDownLatch latch;

    public HostTrackerCallable(HostTracker tracker, IHostId inet) {
        this.trackedHost = inet;
        this.hostTracker = tracker;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public HostNodeConnector call() throws Exception {
        HostNodeConnector h = this.hostTracker.hostFind(this.trackedHost);
        if (h != null) {
            return h;
        }
        this.hostTracker.setCallableOnPendingARP(this.trackedHost, this);
        Thread.sleep(2000L);
        return this.hostTracker.hostQuery(this.trackedHost);
    }

    public void wakeup() {
        this.latch.countDown();
    }
}

