/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.felix.dm.Component;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.hosttracker.HostIdFactory;
import org.opendaylight.controller.hosttracker.IHostId;
import org.opendaylight.controller.hosttracker.IPHostId;
import org.opendaylight.controller.hosttracker.IPMacHostId;
import org.opendaylight.controller.hosttracker.IfHostListener;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.IfNewHostNotify;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.hosttracker.hostAware.IHostFinder;
import org.opendaylight.controller.hosttracker.internal.HostTrackerCallable;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Host;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.Tier;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.packet.address.DataLinkAddress;
import org.opendaylight.controller.sal.packet.address.EthernetAddress;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.ISwitchManagerAware;
import org.opendaylight.controller.switchmanager.Subnet;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.topologymanager.ITopologyManagerAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostTracker
implements IfIptoHost,
IfHostListener,
ISwitchManagerAware,
IInventoryListener,
ITopologyManagerAware,
ICacheUpdateAware<IHostId, HostNodeConnector>,
CommandProvider {
    static final String ACTIVE_HOST_CACHE = "hosttracker.ActiveHosts";
    static final String INACTIVE_HOST_CACHE = "hosttracker.InactiveHosts";
    private static final Logger logger = LoggerFactory.getLogger(HostTracker.class);
    protected final Set<IHostFinder> hostFinder = new CopyOnWriteArraySet<IHostFinder>();
    protected ConcurrentMap<IHostId, HostNodeConnector> hostsDB;
    private ConcurrentMap<NodeConnector, HostNodeConnector> inactiveStaticHosts;
    private final Set<IfNewHostNotify> newHostNotify = Collections.synchronizedSet(new HashSet());
    private ITopologyManager topologyManager;
    protected IClusterContainerServices clusterContainerService = null;
    protected ISwitchManager switchManager = null;
    private Timer timer;
    private Timer arpRefreshTimer;
    private String containerName = null;
    private ExecutorService executor;
    protected boolean stopping;
    private static boolean hostRefresh = true;
    private static int hostRetryCount = 5;
    private String keyScheme = null;
    ConcurrentMap<IHostId, ARPPending> ARPPendingList;
    ConcurrentMap<IHostId, ARPPending> failedARPReqList;

    private void startUp() {
        this.nonClusterObjectCreate();
        this.allocateCache();
        this.retrieveCache();
        this.stopping = false;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new OutStandingARPHandler(), 4000L, 4000L);
        this.executor = Executors.newFixedThreadPool(2);
        this.arpRefreshTimer = new Timer();
        this.arpRefreshTimer.schedule((TimerTask)new ARPRefreshHandler(), 5000L, 5000L);
        this.keyScheme = HostIdFactory.getScheme();
        logger.debug("startUp: Caches created, timers started");
    }

    private void allocateCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't create cache");
            return;
        }
        logger.debug("Creating Cache for HostTracker");
        try {
            this.clusterContainerService.createCache(ACTIVE_HOST_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache(INACTIVE_HOST_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache couldn't be created for HostTracker -  check cache mode");
        }
        catch (CacheExistException cce) {
            logger.error("Cache for HostTracker already exists, destroy and recreate");
        }
        logger.debug("Cache successfully created for HostTracker");
    }

    private void retrieveCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        logger.debug("Retrieving cache for HostTrackerAH");
        this.hostsDB = this.clusterContainerService.getCache(ACTIVE_HOST_CACHE);
        if (this.hostsDB == null) {
            logger.error("Cache couldn't be retrieved for HostTracker");
        }
        logger.debug("Cache was successfully retrieved for HostTracker");
        logger.debug("Retrieving cache for HostTrackerIH");
        this.inactiveStaticHosts = this.clusterContainerService.getCache(INACTIVE_HOST_CACHE);
        if (this.inactiveStaticHosts == null) {
            logger.error("Cache couldn't be retrieved for HostTrackerIH");
        }
        logger.debug("Cache was successfully retrieved for HostTrackerIH");
    }

    public void nonClusterObjectCreate() {
        this.hostsDB = new ConcurrentHashMap<IHostId, HostNodeConnector>();
        this.inactiveStaticHosts = new ConcurrentHashMap<NodeConnector, HostNodeConnector>();
        this.ARPPendingList = new ConcurrentHashMap<IHostId, ARPPending>();
        this.failedARPReqList = new ConcurrentHashMap<IHostId, ARPPending>();
    }

    public void shutDown() {
    }

    public void setnewHostNotify(IfNewHostNotify obj) {
        this.newHostNotify.add(obj);
    }

    public void unsetnewHostNotify(IfNewHostNotify obj) {
        this.newHostNotify.remove(obj);
    }

    public void setArpHandler(IHostFinder hostFinder) {
        if (this.hostFinder != null) {
            this.hostFinder.add(hostFinder);
        }
    }

    public void unsetArpHandler(IHostFinder hostFinder) {
        if (this.hostFinder != null) {
            logger.debug("Arp Handler Service removed!");
            this.hostFinder.remove(hostFinder);
        }
    }

    public void setTopologyManager(ITopologyManager s) {
        this.topologyManager = s;
    }

    public void unsetTopologyManager(ITopologyManager s) {
        if (this.topologyManager == s) {
            logger.debug("Topology Manager Service removed!");
            this.topologyManager = null;
        }
    }

    private boolean hostExists(HostNodeConnector host) {
        IHostId id = HostIdFactory.create((InetAddress)host.getNetworkAddress(), (DataLinkAddress)host.getDataLayerAddress());
        HostNodeConnector lhost = (HostNodeConnector)this.hostsDB.get(id);
        return host.equals((Object)lhost);
    }

    private HostNodeConnector getHostFromOnActiveDB(IHostId id) {
        return (HostNodeConnector)this.hostsDB.get(id);
    }

    private Map.Entry<NodeConnector, HostNodeConnector> getHostFromInactiveDB(IHostId id) {
        for (Map.Entry<NodeConnector, HostNodeConnector> entry : this.inactiveStaticHosts.entrySet()) {
            HostNodeConnector hnc = (HostNodeConnector)entry.getValue();
            IHostId cmpId = HostIdFactory.create((InetAddress)hnc.getNetworkAddress(), (DataLinkAddress)hnc.getDataLayerAddress());
            if (!cmpId.equals(id)) continue;
            logger.debug("getHostFromInactiveDB(): Inactive Host found for ID:{} ", (Object)this.decodeIPFromId(id));
            return entry;
        }
        logger.debug("getHostFromInactiveDB() Inactive Host Not found for ID: {}", (Object)this.decodeIPFromId(id));
        return null;
    }

    private void removeHostFromInactiveDB(IHostId id) {
        NodeConnector nodeConnector = null;
        for (Map.Entry entry : this.inactiveStaticHosts.entrySet()) {
            HostNodeConnector hnc = (HostNodeConnector)entry.getValue();
            IHostId cmpId = HostIdFactory.create((InetAddress)hnc.getNetworkAddress(), (DataLinkAddress)hnc.getDataLayerAddress());
            if (!cmpId.equals(id)) continue;
            nodeConnector = (NodeConnector)entry.getKey();
            break;
        }
        if (nodeConnector != null) {
            this.inactiveStaticHosts.remove(nodeConnector);
            logger.debug("removeHostFromInactiveDB(): Host Removed for IP: {}", (Object)this.decodeIPFromId(id));
            return;
        }
        logger.debug("removeHostFromInactiveDB(): Host Not found for IP: {}", (Object)this.decodeIPFromId(id));
    }

    protected boolean hostMoved(HostNodeConnector host) {
        IHostId id = HostIdFactory.create((InetAddress)host.getNetworkAddress(), (DataLinkAddress)host.getDataLayerAddress());
        return this.hostQuery(id) != null;
    }

    public HostNodeConnector hostQuery(IHostId id) {
        return (HostNodeConnector)this.hostsDB.get(id);
    }

    public Future<HostNodeConnector> discoverHost(IHostId id) {
        if (this.executor == null) {
            logger.debug("discoverHost: Null executor");
            return null;
        }
        HostTrackerCallable worker = new HostTrackerCallable(this, id);
        Future<HostNodeConnector> submit = this.executor.submit(worker);
        return submit;
    }

    public HostNodeConnector hostFind(IHostId id) {
        if (this.hostFinder == null) {
            logger.debug("Exiting hostFind, null hostFinder");
            return null;
        }
        HostNodeConnector host = this.hostQuery(id);
        if (host != null) {
            logger.debug("hostFind(): Host found for IP: {}", (Object)id);
            return host;
        }
        this.addToARPPendingList(id);
        logger.debug("hostFind(): Host Not Found for IP: {}, Inititated Host Discovery ...", (Object)id);
        for (IHostFinder hf : this.hostFinder) {
            InetAddress addr = this.decodeIPFromId(id);
            hf.find(addr);
        }
        return null;
    }

    public Set<HostNodeConnector> getAllHosts() {
        HashSet<HostNodeConnector> allHosts = new HashSet<HostNodeConnector>(this.hostsDB.values());
        return allHosts;
    }

    public Set<HostNodeConnector> getActiveStaticHosts() {
        HashSet<HostNodeConnector> list = new HashSet<HostNodeConnector>();
        for (Map.Entry entry : this.hostsDB.entrySet()) {
            HostNodeConnector host = (HostNodeConnector)entry.getValue();
            if (!host.isStaticHost()) continue;
            list.add(host);
        }
        return list;
    }

    public Set<HostNodeConnector> getInactiveStaticHosts() {
        HashSet<HostNodeConnector> list = new HashSet<HostNodeConnector>(this.inactiveStaticHosts.values());
        return list;
    }

    private void addToARPPendingList(IHostId id) {
        ARPPending arphost = new ARPPending();
        arphost.setHostId(id);
        arphost.setSent_count((short)1);
        this.ARPPendingList.put(id, arphost);
        logger.debug("Host Added to ARPPending List, IP: {}", (Object)this.decodeIPFromId(id));
    }

    public void setCallableOnPendingARP(IHostId id, HostTrackerCallable callable) {
        for (Map.Entry entry : this.ARPPendingList.entrySet()) {
            ARPPending arphost = (ARPPending)entry.getValue();
            if (!arphost.getHostId().equals(id)) continue;
            arphost.setHostTrackerCallable(callable);
        }
    }

    private void processPendingARPReqs(IHostId id) {
        ARPPending arphost = (ARPPending)this.ARPPendingList.remove(id);
        if (arphost != null) {
            logger.debug("Host Removed from ARPPending List, IP: {}", (Object)id);
            HostTrackerCallable htCallable = arphost.getHostTrackerCallable();
            if (htCallable != null) {
                htCallable.wakeup();
            }
            return;
        }
        if (this.failedARPReqList.containsKey(id)) {
            this.failedARPReqList.remove(id);
            logger.debug("Host Removed from FailedARPReqList List, IP: {}", (Object)this.decodeIPFromId(id));
        }
    }

    private void learnNewHost(HostNodeConnector host) {
        IHostId id = HostIdFactory.create((InetAddress)host.getNetworkAddress(), (DataLinkAddress)host.getDataLayerAddress());
        host.initArpSendCountDown();
        HostNodeConnector rHost = this.hostsDB.putIfAbsent(id, host);
        if (rHost != null) {
            this.replaceHost(id, rHost, host);
        } else {
            logger.debug("New Host Learned: MAC: {}  IP: {}", (Object)HexEncode.bytesToHexString((byte[])host.getDataLayerAddressBytes()), (Object)host.getNetworkAddress().getHostAddress());
        }
    }

    private void replaceHost(IHostId id, HostNodeConnector removedHost, HostNodeConnector newHost) {
        NodeConnector newHostNc = newHost.getnodeConnector();
        boolean newHostIsInternal = this.topologyManager.isInternal(newHostNc);
        if (newHostIsInternal) {
            return;
        }
        newHost.initArpSendCountDown();
        if (this.hostsDB.replace(id, removedHost, newHost)) {
            logger.debug("Host move occurred: Old Host IP:{}, New Host IP: {}", (Object)removedHost.getNetworkAddress().getHostAddress(), (Object)newHost.getNetworkAddress().getHostAddress());
            logger.debug("Old Host MAC: {}, New Host MAC: {}", (Object)HexEncode.bytesToHexString((byte[])removedHost.getDataLayerAddressBytes()), (Object)HexEncode.bytesToHexString((byte[])newHost.getDataLayerAddressBytes()));
            logger.debug("Old {}, New {}", (Object)removedHost, (Object)newHost);
        } else {
            this.hostsDB.put(id, newHost);
            logger.error("Host replacement failed. Overwrite the host. Repalced Host: {}, New Host: {}", (Object)removedHost, (Object)newHost);
        }
        this.notifyHostLearnedOrRemoved(removedHost, false);
        this.notifyHostLearnedOrRemoved(newHost, true);
        if (!newHost.isStaticHost()) {
            this.processPendingARPReqs(id);
        }
    }

    private void removeKnownHost(IHostId key) {
        HostNodeConnector host = (HostNodeConnector)this.hostsDB.get(key);
        if (host != null) {
            logger.debug("Removing Host: IP:{}", (Object)host.getNetworkAddress().getHostAddress());
            this.hostsDB.remove(key);
        } else {
            logger.error("removeKnownHost(): Host for IP address {} not found in hostsDB", (Object)this.decodeIPFromId(key));
        }
    }

    public void hostListener(HostNodeConnector host) {
        logger.debug("Received for Host: IP {}, MAC {}, {}", new Object[]{host.getNetworkAddress().getHostAddress(), HexEncode.bytesToHexString((byte[])host.getDataLayerAddressBytes()), host});
        if (this.hostExists(host)) {
            IHostId id = HostIdFactory.create((InetAddress)host.getNetworkAddress(), (DataLinkAddress)host.getDataLayerAddress());
            HostNodeConnector existinghost = (HostNodeConnector)this.hostsDB.get(id);
            existinghost.initArpSendCountDown();
            this.hostsDB.put(id, existinghost);
            logger.debug("hostListener returned without adding the host");
            return;
        }
        new NotifyHostThread(host).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHostLearnedOrRemoved(HostNodeConnector host, boolean add) {
        if (this.newHostNotify != null) {
            logger.debug("Notifying Applications for Host {} Being {}", (Object)host.getNetworkAddress().getHostAddress(), (Object)(add ? "Added" : "Deleted"));
            Set<IfNewHostNotify> set = this.newHostNotify;
            synchronized (set) {
                for (IfNewHostNotify ta : this.newHostNotify) {
                    try {
                        if (add) {
                            ta.notifyHTClient(host);
                            continue;
                        }
                        ta.notifyHTClientHostRemoved(host);
                    }
                    catch (Exception e) {
                        logger.error("Exception on new host notification", (Throwable)e);
                    }
                }
            }
        } else {
            logger.error("notifyHostLearnedOrRemoved(): New host notify is null");
        }
        Node node = host.getnodeconnectorNode();
        Host h = null;
        NodeConnector p = host.getnodeConnector();
        try {
            EthernetAddress dla = new EthernetAddress(host.getDataLayerAddressBytes());
            h = new Host((DataLinkAddress)dla, host.getNetworkAddress());
        }
        catch (ConstructionException ce) {
            p = null;
            h = null;
        }
        if (this.topologyManager != null && p != null && h != null) {
            Tier tier;
            logger.debug("Notifying Topology Manager for Host {} Being {}", (Object)h.getNetworkAddress().getHostAddress(), (Object)(add ? "Added" : "Deleted"));
            if (add) {
                tier = new Tier(1);
                this.switchManager.setNodeProp(node, (Property)tier);
                this.topologyManager.updateHostLink(p, h, UpdateType.ADDED, null);
            } else {
                tier = new Tier(0);
                this.switchManager.setNodeProp(node, (Property)tier);
                this.topologyManager.updateHostLink(p, h, UpdateType.REMOVED, null);
            }
        }
    }

    private void updateSwitchTiers(Node n, int currentTier) {
        Map ndlinks = this.topologyManager.getNodeEdges();
        if (ndlinks == null) {
            logger.debug("updateSwitchTiers(): ndlinks null for Node: {}, Tier:{}", (Object)n, (Object)currentTier);
            return;
        }
        Set links = (Set)ndlinks.get(n);
        if (links == null) {
            logger.debug("updateSwitchTiers(): links null for ndlinks:{}", (Object)ndlinks);
            return;
        }
        ArrayList<Node> needsVisiting = new ArrayList<Node>();
        for (Edge lt : links) {
            Node dstNode;
            if (!lt.getHeadNodeConnector().getType().equals(NodeConnector.NodeConnectorIDType.OPENFLOW) || !this.switchNeedsTieringUpdate(dstNode = lt.getHeadNodeConnector().getNode(), currentTier + 1)) continue;
            Tier t = new Tier(currentTier + 1);
            this.switchManager.setNodeProp(dstNode, (Property)t);
            needsVisiting.add(dstNode);
        }
        for (Node node : needsVisiting) {
            this.updateSwitchTiers(node, currentTier + 1);
        }
    }

    private boolean switchNeedsTieringUpdate(Node n, int tier) {
        if (n == null) {
            logger.error("switchNeedsTieringUpdate(): Null node for tier: {}", (Object)tier);
            return false;
        }
        if (!this.switchManager.getNodes().contains(n)) {
            return false;
        }
        Tier t = (Tier)this.switchManager.getNodeProp(n, "tier");
        if (t == null) {
            return true;
        }
        if (t.getValue() == 0) {
            return true;
        }
        return t.getValue() > tier;
    }

    private void clearTiers() {
        Set nodes = null;
        if (this.switchManager == null) {
            logger.error("clearTiers(): Null switchManager");
            return;
        }
        nodes = this.switchManager.getNodes();
        for (Node n : nodes) {
            Tier t = new Tier(0);
            this.switchManager.setNodeProp(n, (Property)t);
        }
    }

    private void logHierarchies(ArrayList<ArrayList<String>> hierarchies) {
        Object hierarchyString = null;
        int num = 1;
        for (ArrayList<String> hierarchy : hierarchies) {
            StringBuffer buf = new StringBuffer();
            buf.append("Hierarchy#").append(num).append(" : ");
            for (String switchName : hierarchy) {
                buf.append(switchName).append("/");
            }
            logger.debug("{} -> {}", (Object)this.getContainerName(), (Object)buf);
            ++num;
        }
    }

    public List<List<String>> getHostNetworkHierarchy(IHostId id) {
        HostNodeConnector host = this.hostQuery(id);
        if (host == null) {
            return null;
        }
        ArrayList<List<String>> hierarchies = new ArrayList<List<String>>();
        ArrayList<String> currHierarchy = new ArrayList<String>();
        hierarchies.add(currHierarchy);
        Node node = host.getnodeconnectorNode();
        this.updateCurrentHierarchy(node, currHierarchy, hierarchies);
        return hierarchies;
    }

    private String dpidToHostNameHack(long dpid) {
        String hex = Long.toHexString(dpid);
        StringBuffer sb = new StringBuffer();
        int result = 0;
        for (int i = 0; i < hex.length(); ++i) {
            result = (int)(dpid >> i * 8 & 0xFFL);
            if (result == 0) continue;
            if (result < 48) {
                result += 64;
            }
            sb.append(String.format("%c", result));
        }
        return sb.reverse().toString();
    }

    private void updateCurrentHierarchy(Node node, ArrayList<String> currHierarchy, List<List<String>> fullHierarchy) {
        currHierarchy.add((String)this.dpidToHostNameHack((Long)node.getID()));
        ArrayList currHierarchyClone = (ArrayList)currHierarchy.clone();
        Map ndlinks = this.topologyManager.getNodeEdges();
        if (ndlinks == null) {
            logger.debug("updateCurrentHierarchy(): topologyManager returned null ndlinks for node: {}", (Object)node);
            return;
        }
        Node n = NodeCreator.createOFNode((Long)((Long)node.getID()));
        Set links = (Set)ndlinks.get(n);
        if (links == null) {
            logger.debug("updateCurrentHierarchy(): Null links for ndlinks");
            return;
        }
        for (Edge lt : links) {
            if (!lt.getHeadNodeConnector().getType().equals(NodeConnector.NodeConnectorIDType.OPENFLOW)) continue;
            Node dstNode = lt.getHeadNodeConnector().getNode();
            Tier nodeTier = (Tier)this.switchManager.getNodeProp(node, "tier");
            Tier dstNodeTier = (Tier)this.switchManager.getNodeProp(dstNode, "tier");
            if (dstNodeTier == null || dstNodeTier.getValue() <= nodeTier.getValue()) continue;
            ArrayList buildHierarchy = currHierarchy;
            if (currHierarchy.size() > currHierarchyClone.size()) {
                buildHierarchy = (ArrayList)currHierarchyClone.clone();
                fullHierarchy.add(buildHierarchy);
            }
            this.updateCurrentHierarchy(dstNode, buildHierarchy, fullHierarchy);
        }
    }

    private void debugEdgeUpdate(Edge e, UpdateType type, Set<Property> props) {
        Long srcNid = null;
        Short srcPort = null;
        Long dstNid = null;
        Short dstPort = null;
        boolean added = false;
        String srcType = null;
        String dstType = null;
        if (e == null || type == null) {
            logger.error("Edge or Update type are null!");
            return;
        }
        srcType = e.getTailNodeConnector().getType();
        dstType = e.getHeadNodeConnector().getType();
        if (srcType.equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            logger.debug("Skip updates for {}", (Object)e);
            return;
        }
        if (!srcType.equals(NodeConnector.NodeConnectorIDType.OPENFLOW)) {
            logger.debug("For now we cannot handle updates for non-openflow nodes");
            return;
        }
        if (dstType.equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            logger.debug("Skip updates for {}", (Object)e);
            return;
        }
        if (!dstType.equals(NodeConnector.NodeConnectorIDType.OPENFLOW)) {
            logger.debug("For now we cannot handle updates for non-openflow nodes");
            return;
        }
        srcNid = (Long)e.getTailNodeConnector().getNode().getID();
        srcPort = (Short)e.getTailNodeConnector().getID();
        dstNid = (Long)e.getHeadNodeConnector().getNode().getID();
        dstPort = (Short)e.getHeadNodeConnector().getID();
        switch (type) {
            case ADDED: 
            case CHANGED: {
                added = true;
                break;
            }
            case REMOVED: {
                added = false;
            }
        }
        logger.debug("HostTracker Topology linkUpdate handling src:{}[port {}] dst:{}[port {}] added: {}", new Object[]{srcNid, srcPort, dstNid, dstPort, added});
    }

    public void edgeUpdate(List<TopoEdgeUpdate> topoedgeupdateList) {
        if (logger.isDebugEnabled()) {
            for (TopoEdgeUpdate topoEdgeUpdate : topoedgeupdateList) {
                Edge e = topoEdgeUpdate.getEdge();
                Set p = topoEdgeUpdate.getProperty();
                UpdateType type = topoEdgeUpdate.getUpdateType();
                this.debugEdgeUpdate(e, type, p);
            }
        }
    }

    public void subnetNotify(Subnet sub, boolean add) {
        logger.debug("Received subnet notification: {}  add={}", (Object)sub, (Object)add);
        if (add) {
            for (Map.Entry entry : this.failedARPReqList.entrySet()) {
                ARPPending arphost = (ARPPending)entry.getValue();
                if (this.hostFinder == null) {
                    logger.warn("ARPHandler Services are not available on subnet addition");
                    continue;
                }
                logger.debug("Sending the ARP from FailedARPReqList fors IP: {}", (Object)this.decodeIPFromId(arphost.getHostId()));
                for (IHostFinder hf : this.hostFinder) {
                    hf.find(this.decodeIPFromId(arphost.getHostId()));
                }
            }
        }
    }

    protected Status addStaticHostReq(InetAddress networkAddr, byte[] dataLayerAddress, NodeConnector nc, short vlan) {
        if (dataLayerAddress.length != 6) {
            return new Status(StatusCode.BADREQUEST, "Invalid MAC address");
        }
        if (nc == null) {
            return new Status(StatusCode.BADREQUEST, "Invalid NodeConnector");
        }
        HostNodeConnector host = null;
        try {
            host = new HostNodeConnector(dataLayerAddress, networkAddr, nc, vlan);
            IHostId id = HostIdFactory.create((InetAddress)networkAddr, (DataLinkAddress)new EthernetAddress(dataLayerAddress));
            if (this.hostExists(host)) {
                HostNodeConnector transHost = (HostNodeConnector)this.hostsDB.get(networkAddr);
                transHost.setStaticHost(true);
                return new Status(StatusCode.SUCCESS);
            }
            if (this.hostsDB.get(id) != null) {
                return new Status(StatusCode.CONFLICT, "Host with this IP already exists.");
            }
            host.setStaticHost(true);
            if (this.topologyManager != null && this.topologyManager.isInternal(nc)) {
                return new Status(StatusCode.BADREQUEST, "Cannot add host on ISL port");
            }
            if (this.switchManager.isNodeConnectorEnabled(nc).booleanValue()) {
                this.learnNewHost(host);
                this.processPendingARPReqs(id);
                this.notifyHostLearnedOrRemoved(host, true);
            } else {
                this.inactiveStaticHosts.put(nc, host);
                logger.debug("Switch or switchport is not up, adding host {} to inactive list", (Object)networkAddr.getHostName());
            }
            return new Status(StatusCode.SUCCESS);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR, "Host could not be created");
        }
    }

    public Status updateHostReq(InetAddress networkAddr, byte[] dataLayerAddress, NodeConnector nc, short vlan) {
        HostNodeConnector host = null;
        if (dataLayerAddress.length != 6) {
            return new Status(StatusCode.BADREQUEST, "Invalid MAC address");
        }
        if (nc == null) {
            return new Status(StatusCode.BADREQUEST, "Invalid NodeConnector");
        }
        try {
            host = new HostNodeConnector(dataLayerAddress, networkAddr, nc, vlan);
            if (this.hostExists(host)) {
                return new Status(StatusCode.BADREQUEST, "Host already exists");
            }
            IHostId id = HostIdFactory.create((InetAddress)networkAddr, (DataLinkAddress)new EthernetAddress(dataLayerAddress));
            HostNodeConnector tobeUpdatedHost = (HostNodeConnector)this.hostsDB.get(networkAddr);
            if (tobeUpdatedHost != null) {
                if (this.hostsDB.replace(id, tobeUpdatedHost, host)) {
                    logger.debug("Host replaced from hostsDB. Old host: {} New Host: {}", (Object)tobeUpdatedHost, (Object)host);
                    this.notifyHostLearnedOrRemoved(tobeUpdatedHost, false);
                    this.notifyHostLearnedOrRemoved(host, true);
                    return new Status(StatusCode.SUCCESS);
                }
                logger.error("Static host replacement failed from hostsDB, Replaced Host: {}, New Host: {}", (Object)tobeUpdatedHost, (Object)host);
                return new Status(StatusCode.INTERNALERROR, "Host Replacement Failed due to presence of another host with same IP");
            }
            tobeUpdatedHost = (HostNodeConnector)this.inactiveStaticHosts.get(nc);
            if (tobeUpdatedHost != null) {
                if (this.inactiveStaticHosts.replace(nc, tobeUpdatedHost, host)) {
                    logger.debug("Host replaced from inactive hostsDB. Old host: {} New Host: {}", (Object)tobeUpdatedHost, (Object)host);
                    return new Status(StatusCode.SUCCESS);
                }
                logger.error("Static host replacement failed, Replaced Host: {}, New Host: {}", (Object)tobeUpdatedHost, (Object)host);
                return new Status(StatusCode.INTERNALERROR, "Host Replacement Failed due to presence of another host with same IP");
            }
            return new Status(StatusCode.BADREQUEST, "Host doesn't exists, can't update");
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR, "host object creation failure");
        }
    }

    public Status removeStaticHostReq(InetAddress networkAddress, DataLinkAddress mac) {
        IHostId id = HostIdFactory.create((InetAddress)networkAddress, (DataLinkAddress)mac);
        HostNodeConnector host = this.getHostFromOnActiveDB(id);
        if (host != null) {
            if (!host.isStaticHost()) {
                return new Status(StatusCode.FORBIDDEN, "Host " + networkAddress.getHostName() + " is not static");
            }
            this.notifyHostLearnedOrRemoved(host, false);
            this.removeKnownHost(id);
            return new Status(StatusCode.SUCCESS, null);
        }
        Map.Entry<NodeConnector, HostNodeConnector> entry = this.getHostFromInactiveDB(id);
        if (entry != null) {
            host = entry.getValue();
            if (!host.isStaticHost()) {
                return new Status(StatusCode.FORBIDDEN, "Host " + networkAddress.getHostName() + " is not static");
            }
            this.removeHostFromInactiveDB(id);
            return new Status(StatusCode.SUCCESS, null);
        }
        return new Status(StatusCode.NOTFOUND, "Host does not exist");
    }

    public void modeChangeNotify(Node node, boolean proactive) {
        logger.debug("Set Switch {} Mode to {}", node.getID(), (Object)proactive);
    }

    public void notifyNode(Node node, UpdateType type, Map<String, Property> propMap) {
        if (node == null) {
            return;
        }
        switch (type) {
            case REMOVED: {
                logger.debug("Received removed node {}", (Object)node);
                for (Map.Entry entry : this.hostsDB.entrySet()) {
                    HostNodeConnector host = (HostNodeConnector)entry.getValue();
                    if (!host.getnodeconnectorNode().equals((Object)node)) continue;
                    logger.debug("Node: {} is down, remove from Hosts_DB", (Object)node);
                    this.removeKnownHost((IHostId)entry.getKey());
                    this.notifyHostLearnedOrRemoved(host, false);
                }
                break;
            }
        }
    }

    public void notifyNodeConnector(NodeConnector nodeConnector, UpdateType type, Map<String, Property> propMap) {
        if (nodeConnector == null) {
            return;
        }
        boolean up = false;
        switch (type) {
            case ADDED: {
                up = true;
                break;
            }
            case REMOVED: {
                break;
            }
            case CHANGED: {
                State state = (State)propMap.get("state");
                if (state == null || state.getValue() != 1) break;
                up = true;
                break;
            }
            default: {
                return;
            }
        }
        if (up) {
            this.handleNodeConnectorStatusUp(nodeConnector);
        } else {
            this.handleNodeConnectorStatusDown(nodeConnector);
        }
    }

    public Status addStaticHost(String networkAddress, String dataLayerAddress, NodeConnector nc, String vlan) {
        try {
            InetAddress ip = InetAddress.getByName(networkAddress);
            short vl = 0;
            if (!(vlan == null || vlan.isEmpty() || (vl = Short.decode(vlan).shortValue()) >= 1 && vl <= 4095)) {
                return new Status(StatusCode.BADREQUEST, "Host vlan out of range [1 - 4095]");
            }
            return this.addStaticHostReq(ip, HexEncode.bytesFromHexString((String)dataLayerAddress), nc, vl);
        }
        catch (UnknownHostException e) {
            logger.debug("Invalid host IP specified when adding static host", (Throwable)e);
            return new Status(StatusCode.BADREQUEST, "Invalid Host IP Address");
        }
        catch (NumberFormatException nfe) {
            logger.debug("Invalid host vlan or MAC specified when adding static host", (Throwable)nfe);
            return new Status(StatusCode.BADREQUEST, "Invalid Host vLan/MAC");
        }
    }

    public Status removeStaticHost(String networkAddress) {
        try {
            if (this.keyScheme != null && !this.keyScheme.equals("IP")) {
                return new Status(StatusCode.NOTALLOWED, "Host DB Key scheme used is not IP only scheme.");
            }
            InetAddress address = InetAddress.getByName(networkAddress);
            return this.removeStaticHostReq(address, null);
        }
        catch (UnknownHostException e) {
            logger.debug("Invalid IP Address when trying to remove host", (Throwable)e);
            return new Status(StatusCode.BADREQUEST, "Invalid IP Address when trying to remove host");
        }
    }

    public Status removeStaticHostUsingIPAndMac(String networkAddress, String macAddress) {
        try {
            if (this.keyScheme != null && this.keyScheme.equals("IP")) {
                return new Status(StatusCode.NOTALLOWED, "Host DB Key scheme used is not IP only scheme.");
            }
            InetAddress address = InetAddress.getByName(networkAddress);
            EthernetAddress mac = new EthernetAddress(HexEncode.bytesFromHexString((String)macAddress));
            return this.removeStaticHostReq(address, (DataLinkAddress)mac);
        }
        catch (UnknownHostException e) {
            logger.debug("Invalid IP Address when trying to remove host", (Throwable)e);
            return new Status(StatusCode.BADREQUEST, "Invalid IP Address when trying to remove host");
        }
        catch (ConstructionException e) {
            e.printStackTrace();
            return new Status(StatusCode.BADREQUEST, "Invalid Input parameters have been passed.");
        }
    }

    private InetAddress decodeIPFromId(IHostId id) {
        if (this.keyScheme != null && this.keyScheme.equals("IP")) {
            IPHostId ipId = (IPHostId)id;
            return ipId.getIpAddress();
        }
        if (this.keyScheme != null && this.keyScheme.equals("IP+MAC")) {
            IPMacHostId ipMacId = (IPMacHostId)id;
            return ipMacId.getIpAddress();
        }
        return null;
    }

    private DataLinkAddress decodeMacFromId(IHostId id) {
        if (this.keyScheme != null && !this.keyScheme.equals("IP")) {
            IPMacHostId ipMacId = (IPMacHostId)id;
            return ipMacId.getMacAddr();
        }
        return null;
    }

    private void handleNodeConnectorStatusUp(NodeConnector nodeConnector) {
        HostNodeConnector host = null;
        logger.trace("handleNodeConnectorStatusUp {}", (Object)nodeConnector);
        for (Map.Entry entry : this.failedARPReqList.entrySet()) {
            ARPPending arphost = (ARPPending)entry.getValue();
            logger.trace("Sending the ARP from FailedARPReqList fors IP: {}", (Object)arphost.getHostId());
            if (this.hostFinder == null) {
                logger.warn("ARPHandler is not available at interface  up");
                logger.warn("Since this event is missed, host(s) connected to interface {} may not be discovered", (Object)nodeConnector);
                continue;
            }
            try {
                byte[] dataLayerAddress = NetUtils.getBroadcastMACAddr();
                host = new HostNodeConnector(dataLayerAddress, this.decodeIPFromId(arphost.getHostId()), nodeConnector, 0);
                for (IHostFinder hf : this.hostFinder) {
                    hf.probe(host);
                }
            }
            catch (ConstructionException e) {
                logger.debug("HostNodeConnector couldn't be created for Host: {}, NodeConnector: {}", (Object)arphost.getHostId(), (Object)nodeConnector);
                logger.error("", (Throwable)e);
            }
        }
        host = (HostNodeConnector)this.inactiveStaticHosts.get(nodeConnector);
        if (host != null) {
            this.inactiveStaticHosts.remove(nodeConnector);
            this.learnNewHost(host);
            IHostId id = HostIdFactory.create((InetAddress)host.getNetworkAddress(), (DataLinkAddress)host.getDataLayerAddress());
            this.processPendingARPReqs(id);
            this.notifyHostLearnedOrRemoved(host, true);
        }
    }

    private void handleNodeConnectorStatusDown(NodeConnector nodeConnector) {
        logger.trace("handleNodeConnectorStatusDown {}", (Object)nodeConnector);
        for (Map.Entry entry : this.hostsDB.entrySet()) {
            HostNodeConnector host = (HostNodeConnector)entry.getValue();
            if (!host.getnodeConnector().equals((Object)nodeConnector)) continue;
            logger.debug(" NodeConnector: {} is down, remove from Hosts_DB", (Object)nodeConnector);
            this.removeKnownHost((IHostId)entry.getKey());
            this.notifyHostLearnedOrRemoved(host, false);
        }
    }

    void setClusterContainerService(IClusterContainerServices s) {
        logger.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            logger.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    void setSwitchManager(ISwitchManager s) {
        logger.debug("SwitchManager set");
        this.switchManager = s;
    }

    void unsetSwitchManager(ISwitchManager s) {
        if (this.switchManager == s) {
            logger.debug("SwitchManager removed!");
            this.switchManager = null;
        }
    }

    public String getContainerName() {
        if (this.containerName == null) {
            return GlobalConstants.DEFAULT.toString();
        }
        return this.containerName;
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            logger.debug("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        this.startUp();
        logger.debug("key Scheme in hosttracker is {}", (Object)this.keyScheme);
    }

    void destroy() {
    }

    void start() {
        this.registerWithOSGIConsole();
    }

    void stop() {
    }

    void stopping() {
        this.stopping = true;
        this.arpRefreshTimer.cancel();
        this.timer.cancel();
        this.executor.shutdownNow();
    }

    public void edgeOverUtilized(Edge edge) {
    }

    public void edgeUtilBackToNormal(Edge edge) {
    }

    public void entryCreated(IHostId key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
        this.processPendingARPReqs(key);
    }

    public void entryUpdated(IHostId key, HostNodeConnector new_value, String cacheName, boolean originLocal) {
    }

    public void entryDeleted(IHostId key, String cacheName, boolean originLocal) {
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        return null;
    }

    public void _dumpPendingARPReqList(CommandInterpreter ci) {
        for (Map.Entry entry : this.ARPPendingList.entrySet()) {
            ARPPending arphost = (ARPPending)entry.getValue();
            ci.println((Object)arphost.getHostId().toString());
        }
    }

    public void _dumpFailedARPReqList(CommandInterpreter ci) {
        for (Map.Entry entry : this.failedARPReqList.entrySet()) {
            ARPPending arphost = (ARPPending)entry.getValue();
            ci.println((Object)arphost.getHostId().toString());
        }
    }

    public HostNodeConnector hostFind(InetAddress addr) {
        IHostId id = HostIdFactory.create((InetAddress)addr, null);
        return this.hostFind(id);
    }

    public HostNodeConnector hostQuery(InetAddress addr) {
        IHostId id = HostIdFactory.create((InetAddress)addr, null);
        return this.hostQuery(id);
    }

    public Future<HostNodeConnector> discoverHost(InetAddress addr) {
        IHostId id = HostIdFactory.create((InetAddress)addr, null);
        return this.discoverHost(id);
    }

    public List<List<String>> getHostNetworkHierarchy(InetAddress addr) {
        IHostId id = HostIdFactory.create((InetAddress)addr, null);
        return this.getHostNetworkHierarchy(id);
    }

    private class ARPRefreshHandler
    extends TimerTask {
        private ARPRefreshHandler() {
        }

        @Override
        public void run() {
            if (HostTracker.this.stopping) {
                return;
            }
            if (HostTracker.this.clusterContainerService != null && !HostTracker.this.clusterContainerService.amICoordinator()) {
                return;
            }
            if (!hostRefresh) {
                return;
            }
            if (HostTracker.this.hostsDB == null) {
                logger.error("ARPRefreshHandler(): hostsDB is not allocated yet:");
                return;
            }
            for (Map.Entry entry : HostTracker.this.hostsDB.entrySet()) {
                HostNodeConnector host = (HostNodeConnector)entry.getValue();
                if (host.isStaticHost()) continue;
                short arp_cntdown = host.getArpSendCountDown();
                if ((arp_cntdown = (short)(arp_cntdown - 1)) > hostRetryCount) {
                    host.setArpSendCountDown(arp_cntdown);
                    continue;
                }
                if (arp_cntdown <= 0) {
                    HostTracker.this.removeKnownHost((IHostId)entry.getKey());
                    HostTracker.this.notifyHostLearnedOrRemoved(host, false);
                    continue;
                }
                if (arp_cntdown > hostRetryCount) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("ARP Probing ({}) for {}({})", new Object[]{arp_cntdown, host.getNetworkAddress().getHostAddress(), HexEncode.bytesToHexString((byte[])host.getDataLayerAddressBytes())});
                }
                host.setArpSendCountDown(arp_cntdown);
                if (HostTracker.this.hostFinder == null) {
                    logger.trace("ARPHandler is not avaialable, can't send the probe");
                    continue;
                }
                for (IHostFinder hf : HostTracker.this.hostFinder) {
                    hf.probe(host);
                }
            }
        }
    }

    class OutStandingARPHandler
    extends TimerTask {
        OutStandingARPHandler() {
        }

        @Override
        public void run() {
            if (HostTracker.this.stopping) {
                return;
            }
            logger.trace("Number of Entries in ARP Pending/Failed Lists: ARPPendingList = {}, failedARPReqList = {}", (Object)HostTracker.this.ARPPendingList.size(), (Object)HostTracker.this.failedARPReqList.size());
            for (Map.Entry entry : HostTracker.this.ARPPendingList.entrySet()) {
                ARPPending arphost = (ARPPending)entry.getValue();
                if (HostTracker.this.hostsDB.containsKey(arphost.getHostId())) {
                    logger.warn("Learned Host {} found in ARPPendingList", (Object)HostTracker.this.decodeIPFromId(arphost.getHostId()));
                    HostTracker.this.ARPPendingList.remove(entry.getKey());
                    continue;
                }
                if (arphost.getSent_count() < hostRetryCount) {
                    if (HostTracker.this.hostFinder == null) {
                        logger.warn("ARPHandler Services are not available for Outstanding ARPs");
                        continue;
                    }
                    for (IHostFinder hf : HostTracker.this.hostFinder) {
                        hf.find(HostTracker.this.decodeIPFromId(arphost.getHostId()));
                    }
                    arphost.sent_count = (short)(arphost.sent_count + 1);
                    logger.debug("ARP Sent from ARPPending List, IP: {}", (Object)HostTracker.this.decodeIPFromId(arphost.getHostId()));
                    continue;
                }
                if (arphost.getSent_count() >= hostRetryCount) {
                    HostTracker.this.ARPPendingList.remove(entry.getKey());
                    logger.debug("ARP reply not received after multiple attempts, removing from Pending List IP: {}", (Object)HostTracker.this.decodeIPFromId(arphost.getHostId()));
                    logger.debug("Adding the host to FailedARPReqList IP: {}", (Object)HostTracker.this.decodeIPFromId(arphost.getHostId()));
                    HostTracker.this.failedARPReqList.put((IHostId)entry.getKey(), arphost);
                    continue;
                }
                logger.error("Inavlid arp_sent count for entry: {}", entry);
            }
        }
    }

    private class NotifyHostThread
    extends Thread {
        private final HostNodeConnector host;

        public NotifyHostThread(HostNodeConnector h) {
            this.host = h;
        }

        @Override
        public void run() {
            HostNodeConnector removedHost = null;
            InetAddress networkAddr = this.host.getNetworkAddress();
            IHostId id = HostIdFactory.create((InetAddress)networkAddr, (DataLinkAddress)this.host.getDataLayerAddress());
            if (HostTracker.this.hostMoved(this.host)) {
                removedHost = (HostNodeConnector)HostTracker.this.hostsDB.get(id);
                if (removedHost != null) {
                    HostTracker.this.replaceHost(id, removedHost, this.host);
                    return;
                }
                logger.error("Host to be removed not found in hostsDB");
            }
            HostTracker.this.learnNewHost(this.host);
            HostTracker.this.processPendingARPReqs(id);
            HostTracker.this.notifyHostLearnedOrRemoved(this.host, true);
        }
    }

    private static class ARPPending {
        protected IHostId hostId;
        protected short sent_count;
        protected HostTrackerCallable hostTrackerCallable;

        private ARPPending() {
        }

        public IHostId getHostId() {
            return this.hostId;
        }

        public short getSent_count() {
            return this.sent_count;
        }

        public HostTrackerCallable getHostTrackerCallable() {
            return this.hostTrackerCallable;
        }

        public void setHostId(IHostId id) {
            this.hostId = id;
        }

        public void setSent_count(short count) {
            this.sent_count = count;
        }

        public void setHostTrackerCallable(HostTrackerCallable callable) {
            this.hostTrackerCallable = callable;
        }
    }
}

