/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.hosttracker.IfHostListener;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.IfNewHostNotify;
import org.opendaylight.controller.hosttracker.hostAware.IHostFinder;
import org.opendaylight.controller.hosttracker.internal.HostTracker;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.ISwitchManagerAware;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.topologymanager.ITopologyManagerAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{HostTracker.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        if (imp.equals(HostTracker.class)) {
            Hashtable props = new Hashtable();
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("hosttracker.ActiveHosts");
            ((Dictionary)props).put("cachenames", propSet);
            c.setInterface(new String[]{ISwitchManagerAware.class.getName(), IInventoryListener.class.getName(), IfIptoHost.class.getName(), IfHostListener.class.getName(), ITopologyManagerAware.class.getName(), ICacheUpdateAware.class.getName()}, props);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISwitchManager.class).setCallbacks("setSwitchManager", "unsetSwitchManager").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IClusterContainerServices.class).setCallbacks("setClusterContainerService", "unsetClusterContainerService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IHostFinder.class).setCallbacks("setArpHandler", "unsetArpHandler").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ITopologyManager.class).setCallbacks("setTopologyManager", "unsetTopologyManager").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IfNewHostNotify.class).setCallbacks("setnewHostNotify", "unsetnewHostNotify").setRequired(false));
        }
    }
}

