/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Transport;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.ZeroBasedCounter32;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SessionBuilder {
    private DateAndTime _loginTime;
    private Long _sessionId;
    private Host _sourceHost;
    private Class<? extends Transport> _transport;
    private String _username;
    private SessionKey _key;
    private ZeroBasedCounter32 _inBadRpcs;
    private ZeroBasedCounter32 _inRpcs;
    private ZeroBasedCounter32 _outNotifications;
    private ZeroBasedCounter32 _outRpcErrors;
    private Map<Class<? extends Augmentation<Session>>, Augmentation<Session>> augmentation = new HashMap<Class<? extends Augmentation<Session>>, Augmentation<Session>>();

    public SessionBuilder() {
    }

    public SessionBuilder(CommonCounters arg) {
        this._inBadRpcs = arg.getInBadRpcs();
        this._inRpcs = arg.getInRpcs();
        this._outNotifications = arg.getOutNotifications();
        this._outRpcErrors = arg.getOutRpcErrors();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonCounters) {
            this._inBadRpcs = ((CommonCounters)arg).getInBadRpcs();
            this._inRpcs = ((CommonCounters)arg).getInRpcs();
            this._outNotifications = ((CommonCounters)arg).getOutNotifications();
            this._outRpcErrors = ((CommonCounters)arg).getOutRpcErrors();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters] \nbut was: " + arg);
        }
    }

    public DateAndTime getLoginTime() {
        return this._loginTime;
    }

    public Long getSessionId() {
        return this._sessionId;
    }

    public Host getSourceHost() {
        return this._sourceHost;
    }

    public Class<? extends Transport> getTransport() {
        return this._transport;
    }

    public String getUsername() {
        return this._username;
    }

    public SessionKey getKey() {
        return this._key;
    }

    public ZeroBasedCounter32 getInBadRpcs() {
        return this._inBadRpcs;
    }

    public ZeroBasedCounter32 getInRpcs() {
        return this._inRpcs;
    }

    public ZeroBasedCounter32 getOutNotifications() {
        return this._outNotifications;
    }

    public ZeroBasedCounter32 getOutRpcErrors() {
        return this._outRpcErrors;
    }

    public <E extends Augmentation<Session>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SessionBuilder setLoginTime(DateAndTime value) {
        this._loginTime = value;
        return this;
    }

    public SessionBuilder setSessionId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("1"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._sessionId = value;
        return this;
    }

    public SessionBuilder setSourceHost(Host value) {
        this._sourceHost = value;
        return this;
    }

    public SessionBuilder setTransport(Class<? extends Transport> value) {
        this._transport = value;
        return this;
    }

    public SessionBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public SessionBuilder setKey(SessionKey value) {
        this._key = value;
        return this;
    }

    public SessionBuilder setInBadRpcs(ZeroBasedCounter32 value) {
        this._inBadRpcs = value;
        return this;
    }

    public SessionBuilder setInRpcs(ZeroBasedCounter32 value) {
        this._inRpcs = value;
        return this;
    }

    public SessionBuilder setOutNotifications(ZeroBasedCounter32 value) {
        this._outNotifications = value;
        return this;
    }

    public SessionBuilder setOutRpcErrors(ZeroBasedCounter32 value) {
        this._outRpcErrors = value;
        return this;
    }

    public SessionBuilder addAugmentation(Class<? extends Augmentation<Session>> augmentationType, Augmentation<Session> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Session build() {
        return new SessionImpl(this);
    }

    private static final class SessionImpl
    implements Session {
        private final DateAndTime _loginTime;
        private final Long _sessionId;
        private final Host _sourceHost;
        private final Class<? extends Transport> _transport;
        private final String _username;
        private final SessionKey _key;
        private final ZeroBasedCounter32 _inBadRpcs;
        private final ZeroBasedCounter32 _inRpcs;
        private final ZeroBasedCounter32 _outNotifications;
        private final ZeroBasedCounter32 _outRpcErrors;
        private Map<Class<? extends Augmentation<Session>>, Augmentation<Session>> augmentation = new HashMap<Class<? extends Augmentation<Session>>, Augmentation<Session>>();

        public Class<Session> getImplementedInterface() {
            return Session.class;
        }

        private SessionImpl(SessionBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new SessionKey(builder.getSessionId());
                this._sessionId = builder.getSessionId();
            } else {
                this._key = builder.getKey();
                this._sessionId = this._key.getSessionId();
            }
            this._loginTime = builder.getLoginTime();
            this._sourceHost = builder.getSourceHost();
            this._transport = builder.getTransport();
            this._username = builder.getUsername();
            this._inBadRpcs = builder.getInBadRpcs();
            this._inRpcs = builder.getInRpcs();
            this._outNotifications = builder.getOutNotifications();
            this._outRpcErrors = builder.getOutRpcErrors();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public DateAndTime getLoginTime() {
            return this._loginTime;
        }

        @Override
        public Long getSessionId() {
            return this._sessionId;
        }

        @Override
        public Host getSourceHost() {
            return this._sourceHost;
        }

        @Override
        public Class<? extends Transport> getTransport() {
            return this._transport;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        @Override
        public SessionKey getKey() {
            return this._key;
        }

        @Override
        public ZeroBasedCounter32 getInBadRpcs() {
            return this._inBadRpcs;
        }

        @Override
        public ZeroBasedCounter32 getInRpcs() {
            return this._inRpcs;
        }

        @Override
        public ZeroBasedCounter32 getOutNotifications() {
            return this._outNotifications;
        }

        @Override
        public ZeroBasedCounter32 getOutRpcErrors() {
            return this._outRpcErrors;
        }

        public <E extends Augmentation<Session>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._loginTime == null ? 0 : this._loginTime.hashCode());
            result = 31 * result + (this._sessionId == null ? 0 : this._sessionId.hashCode());
            result = 31 * result + (this._sourceHost == null ? 0 : this._sourceHost.hashCode());
            result = 31 * result + (this._transport == null ? 0 : this._transport.hashCode());
            result = 31 * result + (this._username == null ? 0 : this._username.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._inBadRpcs == null ? 0 : this._inBadRpcs.hashCode());
            result = 31 * result + (this._inRpcs == null ? 0 : this._inRpcs.hashCode());
            result = 31 * result + (this._outNotifications == null ? 0 : this._outNotifications.hashCode());
            result = 31 * result + (this._outRpcErrors == null ? 0 : this._outRpcErrors.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionImpl other = (SessionImpl)obj;
            if (this._loginTime == null ? other._loginTime != null : !this._loginTime.equals((Object)other._loginTime)) {
                return false;
            }
            if (this._sessionId == null ? other._sessionId != null : !this._sessionId.equals(other._sessionId)) {
                return false;
            }
            if (this._sourceHost == null ? other._sourceHost != null : !this._sourceHost.equals((Object)other._sourceHost)) {
                return false;
            }
            if (this._transport == null ? other._transport != null : !this._transport.equals(other._transport)) {
                return false;
            }
            if (this._username == null ? other._username != null : !this._username.equals(other._username)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._inBadRpcs == null ? other._inBadRpcs != null : !this._inBadRpcs.equals((Object)other._inBadRpcs)) {
                return false;
            }
            if (this._inRpcs == null ? other._inRpcs != null : !this._inRpcs.equals((Object)other._inRpcs)) {
                return false;
            }
            if (this._outNotifications == null ? other._outNotifications != null : !this._outNotifications.equals((Object)other._outNotifications)) {
                return false;
            }
            if (this._outRpcErrors == null ? other._outRpcErrors != null : !this._outRpcErrors.equals((Object)other._outRpcErrors)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Session [_loginTime=");
            builder.append(this._loginTime);
            builder.append(", _sessionId=");
            builder.append(this._sessionId);
            builder.append(", _sourceHost=");
            builder.append(this._sourceHost);
            builder.append(", _transport=");
            builder.append(this._transport);
            builder.append(", _username=");
            builder.append(this._username);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _inBadRpcs=");
            builder.append(this._inBadRpcs);
            builder.append(", _inRpcs=");
            builder.append(this._inRpcs);
            builder.append(", _outNotifications=");
            builder.append(this._outNotifications);
            builder.append(", _outRpcErrors=");
            builder.append(this._outRpcErrors);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

