/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.SchemaFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SchemaBuilder {
    private Class<? extends SchemaFormat> _format;
    private String _identifier;
    private List<Schema.Location> _location;
    private Uri _namespace;
    private String _version;
    private SchemaKey _key;
    private Map<Class<? extends Augmentation<Schema>>, Augmentation<Schema>> augmentation = new HashMap<Class<? extends Augmentation<Schema>>, Augmentation<Schema>>();

    public Class<? extends SchemaFormat> getFormat() {
        return this._format;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public List<Schema.Location> getLocation() {
        return this._location;
    }

    public Uri getNamespace() {
        return this._namespace;
    }

    public String getVersion() {
        return this._version;
    }

    public SchemaKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Schema>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SchemaBuilder setFormat(Class<? extends SchemaFormat> value) {
        this._format = value;
        return this;
    }

    public SchemaBuilder setIdentifier(String value) {
        this._identifier = value;
        return this;
    }

    public SchemaBuilder setLocation(List<Schema.Location> value) {
        this._location = value;
        return this;
    }

    public SchemaBuilder setNamespace(Uri value) {
        this._namespace = value;
        return this;
    }

    public SchemaBuilder setVersion(String value) {
        this._version = value;
        return this;
    }

    public SchemaBuilder setKey(SchemaKey value) {
        this._key = value;
        return this;
    }

    public SchemaBuilder addAugmentation(Class<? extends Augmentation<Schema>> augmentationType, Augmentation<Schema> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Schema build() {
        return new SchemaImpl(this);
    }

    private static final class SchemaImpl
    implements Schema {
        private final Class<? extends SchemaFormat> _format;
        private final String _identifier;
        private final List<Schema.Location> _location;
        private final Uri _namespace;
        private final String _version;
        private final SchemaKey _key;
        private Map<Class<? extends Augmentation<Schema>>, Augmentation<Schema>> augmentation = new HashMap<Class<? extends Augmentation<Schema>>, Augmentation<Schema>>();

        public Class<Schema> getImplementedInterface() {
            return Schema.class;
        }

        private SchemaImpl(SchemaBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new SchemaKey(builder.getFormat(), builder.getIdentifier(), builder.getVersion());
                this._format = builder.getFormat();
                this._identifier = builder.getIdentifier();
                this._version = builder.getVersion();
            } else {
                this._key = builder.getKey();
                this._format = this._key.getFormat();
                this._identifier = this._key.getIdentifier();
                this._version = this._key.getVersion();
            }
            this._location = builder.getLocation();
            this._namespace = builder.getNamespace();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Class<? extends SchemaFormat> getFormat() {
            return this._format;
        }

        @Override
        public String getIdentifier() {
            return this._identifier;
        }

        @Override
        public List<Schema.Location> getLocation() {
            return this._location;
        }

        @Override
        public Uri getNamespace() {
            return this._namespace;
        }

        @Override
        public String getVersion() {
            return this._version;
        }

        @Override
        public SchemaKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Schema>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._format == null ? 0 : this._format.hashCode());
            result = 31 * result + (this._identifier == null ? 0 : this._identifier.hashCode());
            result = 31 * result + (this._location == null ? 0 : this._location.hashCode());
            result = 31 * result + (this._namespace == null ? 0 : this._namespace.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaImpl other = (SchemaImpl)obj;
            if (this._format == null ? other._format != null : !this._format.equals(other._format)) {
                return false;
            }
            if (this._identifier == null ? other._identifier != null : !this._identifier.equals(other._identifier)) {
                return false;
            }
            if (this._location == null ? other._location != null : !this._location.equals(other._location)) {
                return false;
            }
            if (this._namespace == null ? other._namespace != null : !this._namespace.equals((Object)other._namespace)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Schema [_format=");
            builder.append(this._format);
            builder.append(", _identifier=");
            builder.append(this._identifier);
            builder.append(", _location=");
            builder.append(this._location);
            builder.append(", _namespace=");
            builder.append(this._namespace);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

