/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfDatastoreType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.Datastore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.DatastoreKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.Locks;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class DatastoreBuilder {
    private Locks _locks;
    private NetconfDatastoreType _name;
    private DatastoreKey _key;
    private Map<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>> augmentation = new HashMap<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>>();

    public Locks getLocks() {
        return this._locks;
    }

    public NetconfDatastoreType getName() {
        return this._name;
    }

    public DatastoreKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Datastore>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DatastoreBuilder setLocks(Locks value) {
        this._locks = value;
        return this;
    }

    public DatastoreBuilder setName(NetconfDatastoreType value) {
        this._name = value;
        return this;
    }

    public DatastoreBuilder setKey(DatastoreKey value) {
        this._key = value;
        return this;
    }

    public DatastoreBuilder addAugmentation(Class<? extends Augmentation<Datastore>> augmentationType, Augmentation<Datastore> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Datastore build() {
        return new DatastoreImpl(this);
    }

    private static final class DatastoreImpl
    implements Datastore {
        private final Locks _locks;
        private final NetconfDatastoreType _name;
        private final DatastoreKey _key;
        private Map<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>> augmentation = new HashMap<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>>();

        public Class<Datastore> getImplementedInterface() {
            return Datastore.class;
        }

        private DatastoreImpl(DatastoreBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new DatastoreKey(builder.getName());
                this._name = builder.getName();
            } else {
                this._key = builder.getKey();
                this._name = this._key.getName();
            }
            this._locks = builder.getLocks();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Locks getLocks() {
            return this._locks;
        }

        @Override
        public NetconfDatastoreType getName() {
            return this._name;
        }

        @Override
        public DatastoreKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Datastore>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._locks == null ? 0 : this._locks.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DatastoreImpl other = (DatastoreImpl)obj;
            if (this._locks == null ? other._locks != null : !this._locks.equals(other._locks)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals((Object)other._name)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Datastore [_locks=");
            builder.append(this._locks);
            builder.append(", _name=");
            builder.append((Object)this._name);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

