/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Statistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.ZeroBasedCounter32;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatisticsBuilder {
    private ZeroBasedCounter32 _droppedSessions;
    private ZeroBasedCounter32 _inBadHellos;
    private ZeroBasedCounter32 _inSessions;
    private DateAndTime _netconfStartTime;
    private ZeroBasedCounter32 _inBadRpcs;
    private ZeroBasedCounter32 _inRpcs;
    private ZeroBasedCounter32 _outNotifications;
    private ZeroBasedCounter32 _outRpcErrors;
    private Map<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>();

    public StatisticsBuilder() {
    }

    public StatisticsBuilder(CommonCounters arg) {
        this._inBadRpcs = arg.getInBadRpcs();
        this._inRpcs = arg.getInRpcs();
        this._outNotifications = arg.getOutNotifications();
        this._outRpcErrors = arg.getOutRpcErrors();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonCounters) {
            this._inBadRpcs = ((CommonCounters)arg).getInBadRpcs();
            this._inRpcs = ((CommonCounters)arg).getInRpcs();
            this._outNotifications = ((CommonCounters)arg).getOutNotifications();
            this._outRpcErrors = ((CommonCounters)arg).getOutRpcErrors();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters] \nbut was: " + arg);
        }
    }

    public ZeroBasedCounter32 getDroppedSessions() {
        return this._droppedSessions;
    }

    public ZeroBasedCounter32 getInBadHellos() {
        return this._inBadHellos;
    }

    public ZeroBasedCounter32 getInSessions() {
        return this._inSessions;
    }

    public DateAndTime getNetconfStartTime() {
        return this._netconfStartTime;
    }

    public ZeroBasedCounter32 getInBadRpcs() {
        return this._inBadRpcs;
    }

    public ZeroBasedCounter32 getInRpcs() {
        return this._inRpcs;
    }

    public ZeroBasedCounter32 getOutNotifications() {
        return this._outNotifications;
    }

    public ZeroBasedCounter32 getOutRpcErrors() {
        return this._outRpcErrors;
    }

    public <E extends Augmentation<Statistics>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StatisticsBuilder setDroppedSessions(ZeroBasedCounter32 value) {
        this._droppedSessions = value;
        return this;
    }

    public StatisticsBuilder setInBadHellos(ZeroBasedCounter32 value) {
        this._inBadHellos = value;
        return this;
    }

    public StatisticsBuilder setInSessions(ZeroBasedCounter32 value) {
        this._inSessions = value;
        return this;
    }

    public StatisticsBuilder setNetconfStartTime(DateAndTime value) {
        this._netconfStartTime = value;
        return this;
    }

    public StatisticsBuilder setInBadRpcs(ZeroBasedCounter32 value) {
        this._inBadRpcs = value;
        return this;
    }

    public StatisticsBuilder setInRpcs(ZeroBasedCounter32 value) {
        this._inRpcs = value;
        return this;
    }

    public StatisticsBuilder setOutNotifications(ZeroBasedCounter32 value) {
        this._outNotifications = value;
        return this;
    }

    public StatisticsBuilder setOutRpcErrors(ZeroBasedCounter32 value) {
        this._outRpcErrors = value;
        return this;
    }

    public StatisticsBuilder addAugmentation(Class<? extends Augmentation<Statistics>> augmentationType, Augmentation<Statistics> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Statistics build() {
        return new StatisticsImpl(this);
    }

    private static final class StatisticsImpl
    implements Statistics {
        private final ZeroBasedCounter32 _droppedSessions;
        private final ZeroBasedCounter32 _inBadHellos;
        private final ZeroBasedCounter32 _inSessions;
        private final DateAndTime _netconfStartTime;
        private final ZeroBasedCounter32 _inBadRpcs;
        private final ZeroBasedCounter32 _inRpcs;
        private final ZeroBasedCounter32 _outNotifications;
        private final ZeroBasedCounter32 _outRpcErrors;
        private Map<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>();

        public Class<Statistics> getImplementedInterface() {
            return Statistics.class;
        }

        private StatisticsImpl(StatisticsBuilder builder) {
            this._droppedSessions = builder.getDroppedSessions();
            this._inBadHellos = builder.getInBadHellos();
            this._inSessions = builder.getInSessions();
            this._netconfStartTime = builder.getNetconfStartTime();
            this._inBadRpcs = builder.getInBadRpcs();
            this._inRpcs = builder.getInRpcs();
            this._outNotifications = builder.getOutNotifications();
            this._outRpcErrors = builder.getOutRpcErrors();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public ZeroBasedCounter32 getDroppedSessions() {
            return this._droppedSessions;
        }

        @Override
        public ZeroBasedCounter32 getInBadHellos() {
            return this._inBadHellos;
        }

        @Override
        public ZeroBasedCounter32 getInSessions() {
            return this._inSessions;
        }

        @Override
        public DateAndTime getNetconfStartTime() {
            return this._netconfStartTime;
        }

        @Override
        public ZeroBasedCounter32 getInBadRpcs() {
            return this._inBadRpcs;
        }

        @Override
        public ZeroBasedCounter32 getInRpcs() {
            return this._inRpcs;
        }

        @Override
        public ZeroBasedCounter32 getOutNotifications() {
            return this._outNotifications;
        }

        @Override
        public ZeroBasedCounter32 getOutRpcErrors() {
            return this._outRpcErrors;
        }

        public <E extends Augmentation<Statistics>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._droppedSessions == null ? 0 : this._droppedSessions.hashCode());
            result = 31 * result + (this._inBadHellos == null ? 0 : this._inBadHellos.hashCode());
            result = 31 * result + (this._inSessions == null ? 0 : this._inSessions.hashCode());
            result = 31 * result + (this._netconfStartTime == null ? 0 : this._netconfStartTime.hashCode());
            result = 31 * result + (this._inBadRpcs == null ? 0 : this._inBadRpcs.hashCode());
            result = 31 * result + (this._inRpcs == null ? 0 : this._inRpcs.hashCode());
            result = 31 * result + (this._outNotifications == null ? 0 : this._outNotifications.hashCode());
            result = 31 * result + (this._outRpcErrors == null ? 0 : this._outRpcErrors.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatisticsImpl other = (StatisticsImpl)obj;
            if (this._droppedSessions == null ? other._droppedSessions != null : !this._droppedSessions.equals((Object)other._droppedSessions)) {
                return false;
            }
            if (this._inBadHellos == null ? other._inBadHellos != null : !this._inBadHellos.equals((Object)other._inBadHellos)) {
                return false;
            }
            if (this._inSessions == null ? other._inSessions != null : !this._inSessions.equals((Object)other._inSessions)) {
                return false;
            }
            if (this._netconfStartTime == null ? other._netconfStartTime != null : !this._netconfStartTime.equals((Object)other._netconfStartTime)) {
                return false;
            }
            if (this._inBadRpcs == null ? other._inBadRpcs != null : !this._inBadRpcs.equals((Object)other._inBadRpcs)) {
                return false;
            }
            if (this._inRpcs == null ? other._inRpcs != null : !this._inRpcs.equals((Object)other._inRpcs)) {
                return false;
            }
            if (this._outNotifications == null ? other._outNotifications != null : !this._outNotifications.equals((Object)other._outNotifications)) {
                return false;
            }
            if (this._outRpcErrors == null ? other._outRpcErrors != null : !this._outRpcErrors.equals((Object)other._outRpcErrors)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Statistics [_droppedSessions=");
            builder.append(this._droppedSessions);
            builder.append(", _inBadHellos=");
            builder.append(this._inBadHellos);
            builder.append(", _inSessions=");
            builder.append(this._inSessions);
            builder.append(", _netconfStartTime=");
            builder.append(this._netconfStartTime);
            builder.append(", _inBadRpcs=");
            builder.append(this._inBadRpcs);
            builder.append(", _inRpcs=");
            builder.append(this._inRpcs);
            builder.append(", _outNotifications=");
            builder.append(this._outNotifications);
            builder.append(", _outRpcErrors=");
            builder.append(this._outRpcErrors);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

