/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Datastores;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Statistics;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NetconfStateBuilder {
    private Capabilities _capabilities;
    private Datastores _datastores;
    private Schemas _schemas;
    private Sessions _sessions;
    private Statistics _statistics;
    private Map<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>> augmentation = new HashMap<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>>();

    public Capabilities getCapabilities() {
        return this._capabilities;
    }

    public Datastores getDatastores() {
        return this._datastores;
    }

    public Schemas getSchemas() {
        return this._schemas;
    }

    public Sessions getSessions() {
        return this._sessions;
    }

    public Statistics getStatistics() {
        return this._statistics;
    }

    public <E extends Augmentation<NetconfState>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NetconfStateBuilder setCapabilities(Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public NetconfStateBuilder setDatastores(Datastores value) {
        this._datastores = value;
        return this;
    }

    public NetconfStateBuilder setSchemas(Schemas value) {
        this._schemas = value;
        return this;
    }

    public NetconfStateBuilder setSessions(Sessions value) {
        this._sessions = value;
        return this;
    }

    public NetconfStateBuilder setStatistics(Statistics value) {
        this._statistics = value;
        return this;
    }

    public NetconfStateBuilder addAugmentation(Class<? extends Augmentation<NetconfState>> augmentationType, Augmentation<NetconfState> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NetconfState build() {
        return new NetconfStateImpl(this);
    }

    private static final class NetconfStateImpl
    implements NetconfState {
        private final Capabilities _capabilities;
        private final Datastores _datastores;
        private final Schemas _schemas;
        private final Sessions _sessions;
        private final Statistics _statistics;
        private Map<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>> augmentation = new HashMap<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>>();

        public Class<NetconfState> getImplementedInterface() {
            return NetconfState.class;
        }

        private NetconfStateImpl(NetconfStateBuilder builder) {
            this._capabilities = builder.getCapabilities();
            this._datastores = builder.getDatastores();
            this._schemas = builder.getSchemas();
            this._sessions = builder.getSessions();
            this._statistics = builder.getStatistics();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Datastores getDatastores() {
            return this._datastores;
        }

        @Override
        public Schemas getSchemas() {
            return this._schemas;
        }

        @Override
        public Sessions getSessions() {
            return this._sessions;
        }

        @Override
        public Statistics getStatistics() {
            return this._statistics;
        }

        public <E extends Augmentation<NetconfState>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._capabilities == null ? 0 : this._capabilities.hashCode());
            result = 31 * result + (this._datastores == null ? 0 : this._datastores.hashCode());
            result = 31 * result + (this._schemas == null ? 0 : this._schemas.hashCode());
            result = 31 * result + (this._sessions == null ? 0 : this._sessions.hashCode());
            result = 31 * result + (this._statistics == null ? 0 : this._statistics.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetconfStateImpl other = (NetconfStateImpl)obj;
            if (this._capabilities == null ? other._capabilities != null : !this._capabilities.equals(other._capabilities)) {
                return false;
            }
            if (this._datastores == null ? other._datastores != null : !this._datastores.equals(other._datastores)) {
                return false;
            }
            if (this._schemas == null ? other._schemas != null : !this._schemas.equals(other._schemas)) {
                return false;
            }
            if (this._sessions == null ? other._sessions != null : !this._sessions.equals(other._sessions)) {
                return false;
            }
            if (this._statistics == null ? other._statistics != null : !this._statistics.equals(other._statistics)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NetconfState [_capabilities=");
            builder.append(this._capabilities);
            builder.append(", _datastores=");
            builder.append(this._datastores);
            builder.append(", _schemas=");
            builder.append(this._schemas);
            builder.append(", _sessions=");
            builder.append(this._sessions);
            builder.append(", _statistics=");
            builder.append(this._statistics);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

