/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.statisticsmanager.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.sal.connection.ConnectionLocality;
import org.opendaylight.controller.sal.core.IContainer;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.NodeTable;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.inventory.IListenInventoryUpdates;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.IReadService;
import org.opendaylight.controller.sal.reader.IReadServiceListener;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.statisticsmanager.IStatisticsManager;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsManager
implements IStatisticsManager,
IReadServiceListener,
IListenInventoryUpdates,
ICacheUpdateAware<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(StatisticsManager.class);
    private IContainer container;
    private IClusterContainerServices clusterContainerService;
    private IReadService reader;
    private IConnectionManager connectionManager;
    private ConcurrentMap<Node, List<FlowOnNode>> flowStatistics;
    private ConcurrentMap<Node, List<NodeConnectorStatistics>> nodeConnectorStatistics;
    private ConcurrentMap<Node, List<NodeTableStatistics>> tableStatistics;
    private ConcurrentMap<Node, NodeDescription> descriptionStatistics;
    private ConcurrentMap<Node, CountDownLatch> latches = new ConcurrentHashMap<Node, CountDownLatch>();
    private static long latchTimeout = 30L;
    private ConcurrentMap<Integer, Node> triggers;
    private AtomicInteger triggerKey = new AtomicInteger();
    private ExecutorService triggerExecutor;
    static final String TRIGGERS_CACHE = "statisticsmanager.triggers";
    static final String FLOW_STATISTICS_CACHE = "statisticsmanager.flowStatistics";

    private void nonClusterObjectCreate() {
        this.flowStatistics = new ConcurrentHashMap<Node, List<FlowOnNode>>();
        this.nodeConnectorStatistics = new ConcurrentHashMap<Node, List<NodeConnectorStatistics>>();
        this.tableStatistics = new ConcurrentHashMap<Node, List<NodeTableStatistics>>();
        this.descriptionStatistics = new ConcurrentHashMap<Node, NodeDescription>();
        this.triggers = new ConcurrentHashMap<Integer, Node>();
    }

    private void allocateCaches() {
        if (this.clusterContainerService == null) {
            this.nonClusterObjectCreate();
            log.error("Clustering service unavailable. Allocated non-cluster statistics manager cache.");
            return;
        }
        try {
            this.clusterContainerService.createCache(FLOW_STATISTICS_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("statisticsmanager.nodeConnectorStatistics", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("statisticsmanager.tableStatistics", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("statisticsmanager.descriptionStatistics", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache(TRIGGERS_CACHE, EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL, IClusterServices.cacheMode.ASYNC));
        }
        catch (CacheConfigException cce) {
            log.error("Statistics cache configuration invalid - check cache mode");
        }
        catch (CacheExistException ce) {
            log.debug("Skipping statistics cache creation - already present");
        }
    }

    private void retrieveCaches() {
        if (this.clusterContainerService == null) {
            log.warn("Can't retrieve statistics manager cache, Clustering service unavailable.");
            return;
        }
        log.debug("Statistics Manager - retrieveCaches for Container {}", (Object)this.container);
        ConcurrentMap map = this.clusterContainerService.getCache(FLOW_STATISTICS_CACHE);
        if (map != null) {
            this.flowStatistics = map;
        } else {
            log.error("Cache allocation failed for statisticsmanager.flowStatistics in container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("statisticsmanager.nodeConnectorStatistics");
        if (map != null) {
            this.nodeConnectorStatistics = map;
        } else {
            log.error("Cache allocation failed for statisticsmanager.nodeConnectorStatistics in container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("statisticsmanager.tableStatistics");
        if (map != null) {
            this.tableStatistics = map;
        } else {
            log.error("Cache allocation failed for statisticsmanager.tableStatistics in container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("statisticsmanager.descriptionStatistics");
        if (map != null) {
            this.descriptionStatistics = map;
        } else {
            log.error("Cache allocation failed for statisticsmanager.descriptionStatistics in container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache(TRIGGERS_CACHE);
        if (map != null) {
            this.triggers = map;
        } else {
            log.error("Cache allocation failed for statisticsmanager.triggers in container {}", (Object)this.container.getName());
        }
    }

    void init() {
        log.debug("INIT called!");
        this.allocateCaches();
        this.retrieveCaches();
    }

    void destroy() {
        log.debug("DESTROY called!");
    }

    void start() {
        log.debug("START called!");
        this.triggerExecutor = Executors.newSingleThreadExecutor();
    }

    void started() {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)this.container.getName(), (Object)this);
        if (this.reader != null && switchManager != null) {
            Set nodeSet = switchManager.getNodes();
            for (Node node : nodeSet) {
                List ncStats;
                List tableStats;
                NodeDescription descr;
                List flows = this.reader.readAllFlows(node);
                if (flows != null) {
                    this.flowStatistics.put(node, flows);
                }
                if ((descr = this.reader.readDescription(node)) != null) {
                    this.descriptionStatistics.put(node, descr);
                }
                if ((tableStats = this.reader.readNodeTable(node)) != null) {
                    this.tableStatistics.put(node, tableStats);
                }
                if ((ncStats = this.reader.readNodeConnectors(node)) == null) continue;
                this.nodeConnectorStatistics.put(node, ncStats);
            }
        } else {
            log.trace("Failed to retrieve current statistics. Statistics will not be immediately available!");
        }
    }

    void stop() {
        log.debug("STOP called!");
        this.triggerExecutor.shutdownNow();
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.debug("Cluster Service set for Statistics Mgr");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.debug("Cluster Service removed for Statistics Mgr!");
            this.clusterContainerService = null;
        }
    }

    void setIContainer(IContainer c) {
        this.container = c;
    }

    public void unsetIContainer(IContainer s) {
        if (this.container == s) {
            this.container = null;
        }
    }

    public void setReaderService(IReadService service) {
        log.debug("Got inventory service set request {}", (Object)service);
        this.reader = service;
    }

    public void unsetReaderService(IReadService service) {
        log.debug("Got a service UNset request {}", (Object)service);
        this.reader = null;
    }

    public List<FlowOnNode> getFlows(Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<FlowOnNode> flowList = new ArrayList<FlowOnNode>();
        List cachedList = (List)this.flowStatistics.get(node);
        if (cachedList != null) {
            flowList.addAll(cachedList);
        }
        return flowList;
    }

    public List<FlowOnNode> getFlowsNoCache(Node node) {
        List flows;
        if (node == null) {
            return Collections.emptyList();
        }
        ConnectionLocality locality = ConnectionLocality.LOCAL;
        if (this.connectionManager != null) {
            locality = this.connectionManager.getLocalityStatus(node);
        }
        if (locality == ConnectionLocality.NOT_LOCAL) {
            CountDownLatch newLatch = new CountDownLatch(1);
            CountDownLatch oldLatch = this.latches.putIfAbsent(node, newLatch);
            this.triggers.put(this.triggerKey.incrementAndGet(), node);
            try {
                boolean retStatus = oldLatch != null ? oldLatch.await(latchTimeout, TimeUnit.SECONDS) : newLatch.await(latchTimeout, TimeUnit.SECONDS);
                log.debug("latch timed out {}", (Object)(!retStatus ? 1 : 0));
            }
            catch (InterruptedException e) {
                log.warn("Waiting for statistics response interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.latches.remove(node);
        } else if (this.reader != null && (flows = this.reader.nonCachedReadAllFlows(node)) != null) {
            this.nodeFlowStatisticsUpdated(node, flows);
        }
        return this.getFlows(node);
    }

    public Map<Node, List<FlowOnNode>> getFlowStatisticsForFlowList(List<FlowEntry> flowList) {
        Node node;
        HashMap<Node, List<FlowOnNode>> statMapOutput = new HashMap<Node, List<FlowOnNode>>();
        if (flowList == null || flowList.isEmpty()) {
            return statMapOutput;
        }
        HashMap index = new HashMap();
        for (FlowEntry flowEntry : flowList) {
            node = flowEntry.getNode();
            Set<Flow> set = index.containsKey(node) ? (Set)index.get(node) : new HashSet();
            set.add(flowEntry.getFlow());
            index.put(node, set);
        }
        for (Map.Entry entry : index.entrySet()) {
            node = (Node)entry.getKey();
            List flowsPerNode = (List)this.flowStatistics.get(node);
            if (flowsPerNode == null || flowsPerNode.isEmpty()) continue;
            List<FlowOnNode> filteredFlows = statMapOutput.containsKey(node) ? (List)statMapOutput.get(node) : new ArrayList();
            for (FlowOnNode flowOnNode : flowsPerNode) {
                if (!((Set)entry.getValue()).contains(flowOnNode.getFlow())) continue;
                filteredFlows.add(flowOnNode);
            }
            statMapOutput.put(node, filteredFlows);
        }
        return statMapOutput;
    }

    public int getFlowsNumber(Node node) {
        List l;
        if (node == null || (l = (List)this.flowStatistics.get(node)) == null) {
            return -1;
        }
        return l.size();
    }

    public NodeDescription getNodeDescription(Node node) {
        if (node == null) {
            return null;
        }
        NodeDescription nd = (NodeDescription)this.descriptionStatistics.get(node);
        return nd != null ? nd.clone() : null;
    }

    public NodeConnectorStatistics getNodeConnectorStatistics(NodeConnector nodeConnector) {
        if (nodeConnector == null) {
            return null;
        }
        List statList = (List)this.nodeConnectorStatistics.get(nodeConnector.getNode());
        if (statList != null) {
            for (NodeConnectorStatistics stat : statList) {
                if (!stat.getNodeConnector().equals((Object)nodeConnector)) continue;
                return stat;
            }
        }
        return null;
    }

    public List<NodeConnectorStatistics> getNodeConnectorStatistics(Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeConnectorStatistics> statList = new ArrayList<NodeConnectorStatistics>();
        List cachedList = (List)this.nodeConnectorStatistics.get(node);
        if (cachedList != null) {
            statList.addAll(cachedList);
        }
        return statList;
    }

    public NodeTableStatistics getNodeTableStatistics(NodeTable nodeTable) {
        if (nodeTable == null) {
            return null;
        }
        List statList = (List)this.tableStatistics.get(nodeTable.getNode());
        if (statList != null) {
            for (NodeTableStatistics stat : statList) {
                if (!stat.getNodeTable().getID().equals(nodeTable.getID())) continue;
                return stat;
            }
        }
        return null;
    }

    public List<NodeTableStatistics> getNodeTableStatistics(Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeTableStatistics> statList = new ArrayList<NodeTableStatistics>();
        List cachedList = (List)this.tableStatistics.get(node);
        if (cachedList != null) {
            statList.addAll(cachedList);
        }
        return statList;
    }

    public void nodeFlowStatisticsUpdated(Node node, List<FlowOnNode> flowStatsList) {
        List currentStat = (List)this.flowStatistics.get(node);
        if (!flowStatsList.equals(currentStat)) {
            this.flowStatistics.put(node, flowStatsList);
        }
    }

    public void nodeConnectorStatisticsUpdated(Node node, List<NodeConnectorStatistics> ncStatsList) {
        List currentStat = (List)this.nodeConnectorStatistics.get(node);
        if (!ncStatsList.equals(currentStat)) {
            this.nodeConnectorStatistics.put(node, ncStatsList);
        }
    }

    public void nodeTableStatisticsUpdated(Node node, List<NodeTableStatistics> tableStatsList) {
        List currentStat = (List)this.tableStatistics.get(node);
        if (!tableStatsList.equals(currentStat)) {
            this.tableStatistics.put(node, tableStatsList);
        }
    }

    public void descriptionStatisticsUpdated(Node node, NodeDescription nodeDescription) {
        NodeDescription currentDesc = (NodeDescription)this.descriptionStatistics.get(node);
        if (!nodeDescription.equals((Object)currentDesc)) {
            this.descriptionStatistics.put(node, nodeDescription);
        }
    }

    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        if (type == UpdateType.REMOVED) {
            this.flowStatistics.remove(node);
            this.nodeConnectorStatistics.remove(node);
            this.tableStatistics.remove(node);
            this.descriptionStatistics.remove(node);
        }
    }

    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
    }

    public void unsetIConnectionManager(IConnectionManager s) {
        if (s == this.connectionManager) {
            this.connectionManager = null;
        }
    }

    public void setIConnectionManager(IConnectionManager s) {
        this.connectionManager = s;
    }

    public void entryCreated(Object key, String cacheName, boolean originLocal) {
    }

    public void entryUpdated(Object key, Object new_value, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
        if (cacheName.equals(TRIGGERS_CACHE)) {
            log.trace("Got a trigger for key {} : value {}", key, new_value);
            final Node n = (Node)new_value;
            ConnectionLocality locality = ConnectionLocality.NOT_LOCAL;
            if (this.connectionManager != null) {
                locality = this.connectionManager.getLocalityStatus(n);
            }
            if (locality == ConnectionLocality.LOCAL) {
                log.trace("trigger for node {} processes locally", (Object)n);
                this.triggers.remove(key);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        List flows;
                        if (StatisticsManager.this.reader != null && (flows = StatisticsManager.this.reader.nonCachedReadAllFlows(n)) != null) {
                            StatisticsManager.this.flowStatistics.put(n, flows);
                        }
                    }
                };
                if (this.triggerExecutor != null) {
                    this.triggerExecutor.execute(r);
                }
            }
        } else if (cacheName.equals(FLOW_STATISTICS_CACHE)) {
            log.trace("Got a flow statistics cache update for key {}", key);
            Node n = (Node)key;
            CountDownLatch l = (CountDownLatch)this.latches.get(n);
            if (l != null) {
                l.countDown();
            }
        }
    }

    public void entryDeleted(Object key, String cacheName, boolean originLocal) {
    }
}

