/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.northbound.commons.utils;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.usermanager.IUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorthboundUtils {
    private static final Map<StatusCode, Response.Status> ResponseStatusMapping = new HashMap<StatusCode, Response.Status>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(StatusCode.SUCCESS, Response.Status.OK);
            this.put(StatusCode.BADREQUEST, Response.Status.BAD_REQUEST);
            this.put(StatusCode.UNAUTHORIZED, Response.Status.UNAUTHORIZED);
            this.put(StatusCode.FORBIDDEN, Response.Status.FORBIDDEN);
            this.put(StatusCode.NOTFOUND, Response.Status.NOT_FOUND);
            this.put(StatusCode.NOTALLOWED, Response.Status.FORBIDDEN);
            this.put(StatusCode.NOTACCEPTABLE, Response.Status.NOT_ACCEPTABLE);
            this.put(StatusCode.TIMEOUT, Response.Status.GONE);
            this.put(StatusCode.CONFLICT, Response.Status.CONFLICT);
            this.put(StatusCode.GONE, Response.Status.GONE);
            this.put(StatusCode.UNSUPPORTED, Response.Status.BAD_REQUEST);
            this.put(StatusCode.INTERNALERROR, Response.Status.INTERNAL_SERVER_ERROR);
            this.put(StatusCode.NOTIMPLEMENTED, Response.Status.NOT_ACCEPTABLE);
            this.put(StatusCode.NOSERVICE, Response.Status.SERVICE_UNAVAILABLE);
            this.put(StatusCode.UNDEFINED, Response.Status.BAD_REQUEST);
        }
    };
    private static final String AUDIT = "audit";
    private static final Logger logger = LoggerFactory.getLogger((String)"audit");

    private NorthboundUtils() {
    }

    public static Response.Status getResponseStatus(Status status) {
        return ResponseStatusMapping.get(status.getCode());
    }

    public static Response getResponse(Status status) {
        if (status == null || !ResponseStatusMapping.containsKey(status.getCode())) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Action Result Unknown").build();
        }
        return Response.status((Response.Status)ResponseStatusMapping.get(status.getCode())).entity((Object)status.getDescription()).build();
    }

    public static boolean isAuthorized(String userName, String containerName, Privilege required, Object bundle) {
        if (containerName.equals(GlobalConstants.DEFAULT.toString())) {
            IUserManager auth = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)bundle);
            switch (required) {
                case WRITE: {
                    return auth.getUserLevel(userName).ordinal() <= UserLevel.NETWORKADMIN.ordinal();
                }
                case READ: {
                    return auth.getUserLevel(userName).ordinal() <= UserLevel.NETWORKOPERATOR.ordinal();
                }
            }
            return false;
        }
        IContainerAuthorization auth = (IContainerAuthorization)ServiceHelper.getGlobalInstance(IContainerAuthorization.class, (Object)bundle);
        if (auth == null) {
            return false;
        }
        Privilege current = auth.getResourcePrivilege(userName, (Object)containerName);
        return required.ordinal() <= current.ordinal();
    }

    public static void auditlog(String moduleName, String user, String action, String resource, String containerName) {
        String auditMsg = "";
        String mode = "REST";
        auditMsg = containerName != null ? "Mode: " + mode + " User " + user + " " + action + " " + moduleName + " " + resource + " in container " + containerName : "Mode: " + mode + " User " + user + " " + action + " " + moduleName + " " + resource;
        logger.trace(auditMsg);
    }

    public static void auditlog(String moduleName, String user, String action, String resource) {
        NorthboundUtils.auditlog(moduleName, user, action, resource, null);
    }

    public static String getNodeDesc(Node node, ISwitchManager switchManager) {
        Description desc = (Description)switchManager.getNodeProp(node, "description");
        String description = desc == null ? "" : desc.getValue();
        return description.isEmpty() || description.equalsIgnoreCase("none") ? node.toString() : description;
    }

    public static String getNodeDesc(Node node, String containerName, Object bundle) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)bundle);
        if (switchManager == null) {
            return null;
        }
        return NorthboundUtils.getNodeDesc(node, switchManager);
    }

    public static String getNodeDesc(Node node, Object bundle) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)GlobalConstants.DEFAULT.toString(), (Object)bundle);
        if (switchManager == null) {
            return null;
        }
        return NorthboundUtils.getNodeDesc(node, switchManager);
    }

    public static String getPortName(NodeConnector nodeConnector, String container, Object bundle) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)container, (Object)bundle);
        return NorthboundUtils.getPortName(nodeConnector, switchManager);
    }

    public static String getPortName(NodeConnector nodeConnector, Object bundle) {
        return NorthboundUtils.getPortName(nodeConnector, GlobalConstants.DEFAULT.toString(), bundle);
    }

    public static String getPortName(NodeConnector nodeConnector, ISwitchManager switchManager) {
        Name ncName = (Name)switchManager.getNodeConnectorProp(nodeConnector, "name");
        String nodeConnectorName = ncName != null ? ncName.getValue() : nodeConnector.getNodeConnectorIdAsString();
        nodeConnectorName = nodeConnectorName + "@" + NorthboundUtils.getNodeDesc(nodeConnector.getNode(), switchManager);
        return nodeConnectorName.substring(0, nodeConnectorName.length());
    }
}

