/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.northbound.commons;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.northbound.bundlescanner.IBundleScanService;
import org.opendaylight.controller.northbound.commons.JacksonJsonProcessingExceptionMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorthboundApplication
extends Application {
    public static final String JAXRS_RESOURCES_MANIFEST_NAME = "Jaxrs-Resources";
    public static final String JAXRS_EXCLUDES_MANIFEST_NAME = "Jaxrs-Exclude-Types";
    private static final Logger LOGGER = LoggerFactory.getLogger(NorthboundApplication.class);
    private final Set<Object> _singletons = new HashSet<Object>();

    public NorthboundApplication() {
        this._singletons.add(new ContextResolver<JAXBContext>(){
            JAXBContext jaxbContext;

            public synchronized JAXBContext getContext(Class<?> type) {
                if (this.jaxbContext == null) {
                    this.jaxbContext = NorthboundApplication.this.newJAXBContext();
                }
                return this.jaxbContext;
            }
        });
        this._singletons.add(NorthboundApplication.getJsonProvider());
        this._singletons.add(new JacksonJsonProcessingExceptionMapper());
    }

    public Set<Object> getSingletons() {
        return this._singletons;
    }

    public Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        result.addAll(this.findJAXRSResourceClasses());
        return result;
    }

    private static final JacksonJaxbJsonProvider getJsonProvider() {
        JacksonJaxbJsonProvider jsonProvider = new JacksonJaxbJsonProvider();
        jsonProvider.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return jsonProvider;
    }

    private BundleContext getBundleContext() {
        ClassLoader tlcl = Thread.currentThread().getContextClassLoader();
        Bundle bundle = null;
        if (tlcl instanceof BundleReference) {
            bundle = ((BundleReference)tlcl).getBundle();
        } else {
            LOGGER.warn("Unable to determine the bundle context based on thread context classloader.");
            bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        }
        return bundle == null ? null : bundle.getBundleContext();
    }

    private static final IBundleScanService lookupBundleScanner(BundleContext ctx) {
        ServiceReference svcRef = ctx.getServiceReference(IBundleScanService.class);
        if (svcRef == null) {
            throw new ServiceException("Unable to lookup IBundleScanService");
        }
        return (IBundleScanService)IBundleScanService.class.cast(ctx.getService(svcRef));
    }

    private final JAXBContext newJAXBContext() {
        BundleContext ctx = this.getBundleContext();
        IBundleScanService svc = NorthboundApplication.lookupBundleScanner(ctx);
        try {
            List cls = svc.getAnnotatedClasses(ctx, new String[]{XmlRootElement.class.getPackage().getName()}, this.parseManifestEntry(ctx, JAXRS_EXCLUDES_MANIFEST_NAME), true);
            return JAXBContext.newInstance((Class[])cls.toArray(new Class[cls.size()]));
        }
        catch (JAXBException je) {
            LOGGER.error("Error creating JAXBContext", (Throwable)je);
            return null;
        }
    }

    private final Set<Class<?>> findJAXRSResourceClasses() {
        BundleContext ctx = this.getBundleContext();
        String bundleName = ctx.getBundle().getSymbolicName();
        HashSet result = new HashSet();
        ServiceException recordException = null;
        try {
            IBundleScanService svc = NorthboundApplication.lookupBundleScanner(ctx);
            result.addAll(svc.getAnnotatedClasses(ctx, new String[]{Path.class.getName()}, null, false));
        }
        catch (ServiceException se) {
            recordException = se;
            LOGGER.debug("Error finding JAXRS resource annotated classes in bundle: {} error: {}.", (Object)bundleName, (Object)se.getMessage());
            for (String c : this.parseManifestEntry(ctx, JAXRS_RESOURCES_MANIFEST_NAME)) {
                try {
                    result.add(ctx.getBundle().loadClass(c));
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.error("Cannot load class: {} in bundle: {} defined as MANIFEST JAX-RS resource", new Object[]{c, bundleName, cnfe});
                }
            }
        }
        if (result.size() == 0) {
            if (recordException != null) {
                throw recordException;
            }
            throw new ServiceException("No resource classes found in bundle:" + ctx.getBundle().getSymbolicName());
        }
        return result;
    }

    private final Set<String> parseManifestEntry(BundleContext ctx, String name) {
        HashSet<String> result = new HashSet<String>();
        Dictionary headers = ctx.getBundle().getHeaders();
        String header = (String)headers.get(name);
        if (header != null) {
            for (String s : header.split(",")) {
                if ((s = s.trim()).length() <= 0) continue;
                result.add(s);
            }
        }
        return result;
    }
}

