/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.table.config.rev131024;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.config.rev131024.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.config.rev131024.tables.Table;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class TablesBuilder {
    private List<Table> _table;
    private Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();

    public List<Table> getTable() {
        return this._table;
    }

    public <E extends Augmentation<Tables>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TablesBuilder setTable(List<Table> value) {
        this._table = value;
        return this;
    }

    public TablesBuilder addAugmentation(Class<? extends Augmentation<Tables>> augmentationType, Augmentation<Tables> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Tables build() {
        return new TablesImpl(this);
    }

    private static final class TablesImpl
    implements Tables {
        private final List<Table> _table;
        private Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();

        public Class<Tables> getImplementedInterface() {
            return Tables.class;
        }

        private TablesImpl(TablesBuilder builder) {
            this._table = builder.getTable();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Table> getTable() {
            return this._table;
        }

        public <E extends Augmentation<Tables>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._table == null ? 0 : this._table.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TablesImpl other = (TablesImpl)obj;
            if (this._table == null ? other._table != null : !this._table.equals(other._table)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Tables [_table=");
            builder.append(this._table);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

