/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.queue.config.rev131024.queues;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueConfigRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.config.rev131024.QueueEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.config.rev131024.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.config.rev131024.queues.QueueKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueueBuilder {
    private Long _id;
    private QueueKey _key;
    private NodeConnectorRef _node;
    private Long _port;
    private Map<Class<? extends Augmentation<Queue>>, Augmentation<Queue>> augmentation = new HashMap<Class<? extends Augmentation<Queue>>, Augmentation<Queue>>();

    public QueueBuilder() {
    }

    public QueueBuilder(QueueEntry arg) {
        this._node = arg.getNode();
        this._port = arg.getPort();
    }

    public QueueBuilder(QueueConfigRequest arg) {
        this._port = arg.getPort();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueueConfigRequest) {
            this._port = ((QueueConfigRequest)arg).getPort();
            isValidArg = true;
        }
        if (arg instanceof QueueEntry) {
            this._node = ((QueueEntry)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueConfigRequest, org.opendaylight.yang.gen.v1.urn.opendaylight.queue.config.rev131024.QueueEntry] \nbut was: " + arg);
        }
    }

    public Long getId() {
        return this._id;
    }

    public QueueKey getKey() {
        return this._key;
    }

    public NodeConnectorRef getNode() {
        return this._node;
    }

    public Long getPort() {
        return this._port;
    }

    public <E extends Augmentation<Queue>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueueBuilder setId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._id = value;
        return this;
    }

    public QueueBuilder setKey(QueueKey value) {
        this._key = value;
        return this;
    }

    public QueueBuilder setNode(NodeConnectorRef value) {
        this._node = value;
        return this;
    }

    public QueueBuilder setPort(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._port = value;
        return this;
    }

    public QueueBuilder addAugmentation(Class<? extends Augmentation<Queue>> augmentationType, Augmentation<Queue> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Queue build() {
        return new QueueImpl(this);
    }

    private static final class QueueImpl
    implements Queue {
        private final Long _id;
        private final QueueKey _key;
        private final NodeConnectorRef _node;
        private final Long _port;
        private Map<Class<? extends Augmentation<Queue>>, Augmentation<Queue>> augmentation = new HashMap<Class<? extends Augmentation<Queue>>, Augmentation<Queue>>();

        public Class<Queue> getImplementedInterface() {
            return Queue.class;
        }

        private QueueImpl(QueueBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new QueueKey(builder.getId(), builder.getNode());
                this._id = builder.getId();
                this._node = builder.getNode();
            } else {
                this._key = builder.getKey();
                this._id = this._key.getId();
                this._node = this._key.getNode();
            }
            this._port = builder.getPort();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getId() {
            return this._id;
        }

        @Override
        public QueueKey getKey() {
            return this._key;
        }

        @Override
        public NodeConnectorRef getNode() {
            return this._node;
        }

        public Long getPort() {
            return this._port;
        }

        public <E extends Augmentation<Queue>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueImpl other = (QueueImpl)obj;
            if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Queue [_id=");
            builder.append(this._id);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _port=");
            builder.append(this._port);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

