/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.ports;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.PortEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.ports.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.ports.PortKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortBuilder {
    private Long _id;
    private PortKey _key;
    private NodeRef _node;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.Port _port;
    private Map<Class<? extends Augmentation<Port>>, Augmentation<Port>> augmentation = new HashMap<Class<? extends Augmentation<Port>>, Augmentation<Port>>();

    public PortBuilder() {
    }

    public PortBuilder(PortEntry arg) {
        this._node = arg.getNode();
        this._port = arg.getPort();
    }

    public PortBuilder(PortMod arg) {
        this._port = arg.getPort();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PortMod) {
            this._port = ((PortMod)arg).getPort();
            isValidArg = true;
        }
        if (arg instanceof PortEntry) {
            this._node = ((PortEntry)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortMod, org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.PortEntry] \nbut was: " + arg);
        }
    }

    public Long getId() {
        return this._id;
    }

    public PortKey getKey() {
        return this._key;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.Port getPort() {
        return this._port;
    }

    public <E extends Augmentation<Port>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortBuilder setId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._id = value;
        return this;
    }

    public PortBuilder setKey(PortKey value) {
        this._key = value;
        return this;
    }

    public PortBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public PortBuilder setPort(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.Port value) {
        this._port = value;
        return this;
    }

    public PortBuilder addAugmentation(Class<? extends Augmentation<Port>> augmentationType, Augmentation<Port> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Port build() {
        return new PortImpl(this);
    }

    private static final class PortImpl
    implements Port {
        private final Long _id;
        private final PortKey _key;
        private final NodeRef _node;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.Port _port;
        private Map<Class<? extends Augmentation<Port>>, Augmentation<Port>> augmentation = new HashMap<Class<? extends Augmentation<Port>>, Augmentation<Port>>();

        public Class<Port> getImplementedInterface() {
            return Port.class;
        }

        private PortImpl(PortBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new PortKey(builder.getId(), builder.getNode());
                this._id = builder.getId();
                this._node = builder.getNode();
            } else {
                this._key = builder.getKey();
                this._id = this._key.getId();
                this._node = this._key.getNode();
            }
            this._port = builder.getPort();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getId() {
            return this._id;
        }

        @Override
        public PortKey getKey() {
            return this._key;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        public org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.Port getPort() {
            return this._port;
        }

        public <E extends Augmentation<Port>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortImpl other = (PortImpl)obj;
            if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Port [_id=");
            builder.append(this._id);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _port=");
            builder.append(this._port);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

