/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.Ports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.config.rev131024.ports.Port;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PortsBuilder {
    private List<Port> _port;
    private Map<Class<? extends Augmentation<Ports>>, Augmentation<Ports>> augmentation = new HashMap<Class<? extends Augmentation<Ports>>, Augmentation<Ports>>();

    public List<Port> getPort() {
        return this._port;
    }

    public <E extends Augmentation<Ports>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortsBuilder setPort(List<Port> value) {
        this._port = value;
        return this;
    }

    public PortsBuilder addAugmentation(Class<? extends Augmentation<Ports>> augmentationType, Augmentation<Ports> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ports build() {
        return new PortsImpl(this);
    }

    private static final class PortsImpl
    implements Ports {
        private final List<Port> _port;
        private Map<Class<? extends Augmentation<Ports>>, Augmentation<Ports>> augmentation = new HashMap<Class<? extends Augmentation<Ports>>, Augmentation<Ports>>();

        public Class<Ports> getImplementedInterface() {
            return Ports.class;
        }

        private PortsImpl(PortsBuilder builder) {
            this._port = builder.getPort();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Port> getPort() {
            return this._port;
        }

        public <E extends Augmentation<Ports>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortsImpl other = (PortsImpl)obj;
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Ports [_port=");
            builder.append(this._port);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

