/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.config.rev131024;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.config.rev131024.Meters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.config.rev131024.meters.Meter;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MetersBuilder {
    private List<Meter> _meter;
    private Map<Class<? extends Augmentation<Meters>>, Augmentation<Meters>> augmentation = new HashMap<Class<? extends Augmentation<Meters>>, Augmentation<Meters>>();

    public List<Meter> getMeter() {
        return this._meter;
    }

    public <E extends Augmentation<Meters>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MetersBuilder setMeter(List<Meter> value) {
        this._meter = value;
        return this;
    }

    public MetersBuilder addAugmentation(Class<? extends Augmentation<Meters>> augmentationType, Augmentation<Meters> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Meters build() {
        return new MetersImpl(this);
    }

    private static final class MetersImpl
    implements Meters {
        private final List<Meter> _meter;
        private Map<Class<? extends Augmentation<Meters>>, Augmentation<Meters>> augmentation = new HashMap<Class<? extends Augmentation<Meters>>, Augmentation<Meters>>();

        public Class<Meters> getImplementedInterface() {
            return Meters.class;
        }

        private MetersImpl(MetersBuilder builder) {
            this._meter = builder.getMeter();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Meter> getMeter() {
            return this._meter;
        }

        public <E extends Augmentation<Meters>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meter == null ? 0 : this._meter.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetersImpl other = (MetersImpl)obj;
            if (this._meter == null ? other._meter != null : !this._meter.equals(other._meter)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Meters [_meter=");
            builder.append(this._meter);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

