/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.config.rev131024.groups;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.config.rev131024.GroupEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.config.rev131024.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.config.rev131024.groups.GroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupBuilder {
    private Long _id;
    private GroupKey _key;
    private NodeRef _node;
    private Boolean _barrier;
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupTypes _groupType;
    private Map<Class<? extends Augmentation<Group>>, Augmentation<Group>> augmentation = new HashMap<Class<? extends Augmentation<Group>>, Augmentation<Group>>();

    public GroupBuilder() {
    }

    public GroupBuilder(GroupEntry arg) {
        this._node = arg.getNode();
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
        this._containerName = arg.getContainerName();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._groupType = arg.getGroupType();
    }

    public GroupBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group arg) {
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
        this._containerName = arg.getContainerName();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._groupType = arg.getGroupType();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GroupEntry) {
            this._node = ((GroupEntry)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group) {
            this._barrier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)arg).isBarrier();
            this._buckets = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)arg).getBuckets();
            this._containerName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)arg).getContainerName();
            this._groupId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)arg).getGroupId();
            this._groupName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)arg).getGroupName();
            this._groupType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)arg).getGroupType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.config.rev131024.GroupEntry, org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group] \nbut was: " + arg);
        }
    }

    public Long getId() {
        return this._id;
    }

    public GroupKey getKey() {
        return this._key;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public <E extends Augmentation<Group>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupBuilder setId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._id = value;
        return this;
    }

    public GroupBuilder setKey(GroupKey value) {
        this._key = value;
        return this;
    }

    public GroupBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public GroupBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public GroupBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public GroupBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public GroupBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public GroupBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public GroupBuilder addAugmentation(Class<? extends Augmentation<Group>> augmentationType, Augmentation<Group> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Group build() {
        return new GroupImpl(this);
    }

    private static final class GroupImpl
    implements Group {
        private final Long _id;
        private final GroupKey _key;
        private final NodeRef _node;
        private final Boolean _barrier;
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupTypes _groupType;
        private Map<Class<? extends Augmentation<Group>>, Augmentation<Group>> augmentation = new HashMap<Class<? extends Augmentation<Group>>, Augmentation<Group>>();

        public Class<Group> getImplementedInterface() {
            return Group.class;
        }

        private GroupImpl(GroupBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new GroupKey(builder.getId(), builder.getNode());
                this._id = builder.getId();
                this._node = builder.getNode();
            } else {
                this._key = builder.getKey();
                this._id = this._key.getId();
                this._node = this._key.getNode();
            }
            this._barrier = builder.isBarrier();
            this._buckets = builder.getBuckets();
            this._containerName = builder.getContainerName();
            this._groupId = builder.getGroupId();
            this._groupName = builder.getGroupName();
            this._groupType = builder.getGroupType();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getId() {
            return this._id;
        }

        @Override
        public GroupKey getKey() {
            return this._key;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        public <E extends Augmentation<Group>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._buckets == null ? 0 : this._buckets.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._groupName == null ? 0 : this._groupName.hashCode());
            result = 31 * result + (this._groupType == null ? 0 : this._groupType.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupImpl other = (GroupImpl)obj;
            if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._buckets == null ? other._buckets != null : !this._buckets.equals(other._buckets)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals((Object)other._groupId)) {
                return false;
            }
            if (this._groupName == null ? other._groupName != null : !this._groupName.equals(other._groupName)) {
                return false;
            }
            if (this._groupType == null ? other._groupType != null : !this._groupType.equals((Object)other._groupType)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Group [_id=");
            builder.append(this._id);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _barrier=");
            builder.append(this._barrier);
            builder.append(", _buckets=");
            builder.append(this._buckets);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", _groupName=");
            builder.append(this._groupName);
            builder.append(", _groupType=");
            builder.append(this._groupType);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

