/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.config.rev130819;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.config.rev130819.Flows;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.config.rev130819.flows.Flow;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class FlowsBuilder {
    private List<Flow> _flow;
    private Map<Class<? extends Augmentation<Flows>>, Augmentation<Flows>> augmentation = new HashMap<Class<? extends Augmentation<Flows>>, Augmentation<Flows>>();

    public List<Flow> getFlow() {
        return this._flow;
    }

    public <E extends Augmentation<Flows>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowsBuilder setFlow(List<Flow> value) {
        this._flow = value;
        return this;
    }

    public FlowsBuilder addAugmentation(Class<? extends Augmentation<Flows>> augmentationType, Augmentation<Flows> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Flows build() {
        return new FlowsImpl(this);
    }

    private static final class FlowsImpl
    implements Flows {
        private final List<Flow> _flow;
        private Map<Class<? extends Augmentation<Flows>>, Augmentation<Flows>> augmentation = new HashMap<Class<? extends Augmentation<Flows>>, Augmentation<Flows>>();

        public Class<Flows> getImplementedInterface() {
            return Flows.class;
        }

        private FlowsImpl(FlowsBuilder builder) {
            this._flow = builder.getFlow();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Flow> getFlow() {
            return this._flow;
        }

        public <E extends Augmentation<Flows>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flow == null ? 0 : this._flow.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowsImpl other = (FlowsImpl)obj;
            if (this._flow == null ? other._flow != null : !this._flow.equals(other._flow)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Flows [_flow=");
            builder.append(this._flow);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

