/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.logging.bridge.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum UncaughtExceptionPolicy implements Thread.UncaughtExceptionHandler
{
    ABORT{
        public static final int EXIT_CODE = 1;

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Thread {} died because of an uncaught exception, forcing virtual machine shutdown", (Object)t, (Object)e);
            System.exit(1);
        }
    }
    ,
    IGNORE{

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Thread {} died because of an uncaught exception", (Object)t, (Object)e);
        }
    };

    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(UncaughtExceptionPolicy.class);
    }
}

