/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.logging.bridge.internal;

import java.util.Enumeration;
import org.opendaylight.controller.logging.bridge.internal.LogListenerImpl;
import org.opendaylight.controller.logging.bridge.internal.UncaughtExceptionPolicy;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String UNCAUGHT_EXCEPTION_POLICY_PROP = "controller.uncaughtExceptionPolicy";
    private static final UncaughtExceptionPolicy DEFAULT_UNCAUGHT_EXCEPTION_POLICY = UncaughtExceptionPolicy.IGNORE;
    private LogListenerImpl listener = null;
    private ShutdownHandler shutdownHandler = null;
    private Logger log = null;

    public void start(BundleContext context) {
        ILoggerFactory f = LoggerFactory.getILoggerFactory();
        this.log = f.getLogger("org.opendaylight.controller.logging.bridge.OSGI2SLF4J");
        if (this.log != null) {
            this.listener = new LogListenerImpl(this.log);
            ServiceReference service = null;
            service = context.getServiceReference(LogReaderService.class.getName());
            if (service != null) {
                LogReaderService reader = (LogReaderService)context.getService(service);
                if (reader == null) {
                    this.log.error("Cannot register the LogListener because cannot retrieve LogReaderService");
                } else {
                    reader.addLogListener((LogListener)this.listener);
                    Enumeration entries = reader.getLog();
                    if (entries != null) {
                        while (entries.hasMoreElements()) {
                            LogEntry entry = (LogEntry)entries.nextElement();
                            this.listener.logged(entry);
                        }
                    }
                }
                UncaughtExceptionPolicy handler = DEFAULT_UNCAUGHT_EXCEPTION_POLICY;
                String policy = context.getProperty(UNCAUGHT_EXCEPTION_POLICY_PROP);
                if (policy != null) {
                    try {
                        handler = UncaughtExceptionPolicy.valueOf(policy.toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        this.log.warn("Invalid policy name \"{}\", defaulting to {}", (Object)policy, (Object)handler);
                    }
                }
                this.log.trace("Setting uncaught exception policy to {}", (Object)handler);
                Thread.setDefaultUncaughtExceptionHandler(handler);
                this.shutdownHandler = new ShutdownHandler(context);
                Runtime.getRuntime().addShutdownHook(this.shutdownHandler);
            } else {
                this.log.error("Cannot register the LogListener because cannot retrieve LogReaderService");
            }
        } else {
            System.err.println("Could not initialize the logging bridge subsytem");
        }
    }

    public void stop(BundleContext context) {
        ServiceReference serviceRef = context.getServiceReference(LogReaderService.class.getName());
        if (serviceRef != null) {
            LogReaderService reader = (LogReaderService)context.getService(serviceRef);
            reader.removeLogListener((LogListener)this.listener);
        }
        if (this.shutdownHandler != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHandler);
        }
        this.listener = null;
        this.log = null;
        this.shutdownHandler = null;
    }

    private class ShutdownHandler
    extends Thread {
        BundleContext bundlecontext;

        public ShutdownHandler(BundleContext ctxt) {
            this.bundlecontext = ctxt;
        }

        @Override
        public void run() {
            try {
                this.bundlecontext.getBundle(0L).stop();
                Activator.this.log.debug("shutdown handler thread called");
            }
            catch (BundleException e) {
                Activator.this.log.debug("Bundle couldn't be stopped");
            }
            catch (Exception e) {
                Activator.this.log.debug("Unhandled exception");
            }
        }
    }
}

