/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.concepts.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QName
implements Immutable,
Serializable {
    private static final long serialVersionUID = 5398411242927766414L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(QName.class);
    private static final ThreadLocal<SimpleDateFormat> REVISION_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }

        @Override
        public void set(SimpleDateFormat value) {
            throw new UnsupportedOperationException();
        }
    };
    static final String QNAME_REVISION_DELIMITER = "?revision=";
    static final String QNAME_LEFT_PARENTHESIS = "(";
    static final String QNAME_RIGHT_PARENTHESIS = ")";
    private final URI namespace;
    private final String localName;
    private final String prefix;
    private final String formattedRevision;
    private final Date revision;
    private static Pattern QNAME_PATTERN_FULL = Pattern.compile("^\\((.+)\\?revision=(.+)\\)(.+)$");
    private static Pattern QNAME_PATTERN_NO_REVISION = Pattern.compile("^\\((.+)\\)(.+)$");
    private static Pattern QNAME_PATTERN_NO_NAMESPACE_NO_REVISION = Pattern.compile("^(.+)$");

    public QName(URI namespace, Date revision, String prefix, String localName) {
        this.localName = QName.checkLocalName(localName);
        this.namespace = namespace;
        this.revision = revision;
        this.prefix = prefix;
        this.formattedRevision = revision != null ? REVISION_FORMAT.get().format(revision) : null;
    }

    public QName(URI namespace, String localName) {
        this(namespace, null, "", localName);
    }

    private static String checkLocalName(String localName) {
        String[] illegalSubstrings;
        if (localName == null) {
            throw new IllegalArgumentException("Parameter 'localName' may not be null.");
        }
        if (localName.length() == 0) {
            throw new IllegalArgumentException("Parameter 'localName' must be a non-empty string.");
        }
        for (String illegalSubstring : illegalSubstrings = new String[]{"?", QNAME_LEFT_PARENTHESIS, QNAME_RIGHT_PARENTHESIS, "&"}) {
            if (!localName.contains(illegalSubstring)) continue;
            throw new IllegalArgumentException(String.format("Parameter 'localName':'%s' contains illegal sequence '%s'", localName, illegalSubstring));
        }
        return localName;
    }

    public QName(URI namespace, Date revision, String localName) {
        this(namespace, revision, null, localName);
    }

    public QName(QName base, String localName) {
        this(base.getNamespace(), base.getRevision(), base.getPrefix(), localName);
    }

    @Deprecated
    public QName(String input) throws ParseException {
        Date revision = null;
        String nsAndRev = input.substring(input.indexOf(QNAME_LEFT_PARENTHESIS) + 1, input.indexOf(QNAME_RIGHT_PARENTHESIS));
        if (nsAndRev.contains("?")) {
            String[] splitted = nsAndRev.split("\\?");
            this.namespace = URI.create(splitted[0]);
            revision = REVISION_FORMAT.get().parse(splitted[1]);
        } else {
            this.namespace = URI.create(nsAndRev);
        }
        this.localName = QName.checkLocalName(input.substring(input.indexOf(QNAME_RIGHT_PARENTHESIS) + 1));
        this.revision = revision;
        this.prefix = null;
        this.formattedRevision = revision != null ? REVISION_FORMAT.get().format(revision) : null;
    }

    public static QName create(String input) {
        Matcher matcher = QNAME_PATTERN_FULL.matcher(input);
        if (matcher.matches()) {
            String namespace = matcher.group(1);
            String revision = matcher.group(2);
            String localName = matcher.group(3);
            return QName.create(namespace, revision, localName);
        }
        matcher = QNAME_PATTERN_NO_REVISION.matcher(input);
        if (matcher.matches()) {
            URI namespace = URI.create(matcher.group(1));
            String localName = matcher.group(2);
            return new QName(namespace, localName);
        }
        matcher = QNAME_PATTERN_NO_NAMESPACE_NO_REVISION.matcher(input);
        if (matcher.matches()) {
            String localName = matcher.group(1);
            return new QName((URI)null, localName);
        }
        throw new IllegalArgumentException("Invalid input:" + input);
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Date getRevision() {
        return this.revision;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.formattedRevision == null ? 0 : this.formattedRevision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QName other = (QName)obj;
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.formattedRevision == null ? other.formattedRevision != null : !this.revision.equals(other.revision));
    }

    public static QName create(QName base, String localName) {
        return new QName(base, localName);
    }

    public static QName create(URI namespace, Date revision, String localName) {
        return new QName(namespace, revision, localName);
    }

    public static QName create(String namespace, String revision, String localName) throws IllegalArgumentException {
        try {
            URI namespaceUri = new URI(namespace);
            Date revisionDate = QName.parseRevision(revision);
            return QName.create(namespaceUri, revisionDate, localName);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException("Namespace is is not valid URI", ue);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.namespace != null) {
            sb.append(QNAME_LEFT_PARENTHESIS + this.namespace);
            if (this.revision != null) {
                sb.append(QNAME_REVISION_DELIMITER + REVISION_FORMAT.get().format(this.revision));
            }
            sb.append(QNAME_RIGHT_PARENTHESIS);
        }
        sb.append(this.localName);
        return sb.toString();
    }

    URI getRevisionNamespace() {
        if (this.namespace == null) {
            return null;
        }
        String query = "";
        if (this.revision != null) {
            query = "revision=" + this.formattedRevision;
        }
        URI compositeURI = null;
        try {
            compositeURI = new URI(this.namespace.getScheme(), this.namespace.getUserInfo(), this.namespace.getHost(), this.namespace.getPort(), this.namespace.getPath(), query, this.namespace.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.error("", (Throwable)e);
        }
        return compositeURI;
    }

    public String getFormattedRevision() {
        return this.formattedRevision;
    }

    public QName withoutRevision() {
        return QName.create(this.namespace, null, this.localName);
    }

    public static Date parseRevision(String formatedDate) {
        try {
            return REVISION_FORMAT.get().parse(formatedDate);
        }
        catch (RuntimeException | ParseException e) {
            throw new IllegalArgumentException("Revision is not in supported format:" + formatedDate, e);
        }
    }

    public static String formattedRevision(Date revision) {
        if (revision == null) {
            return null;
        }
        return REVISION_FORMAT.get().format(revision);
    }

    public boolean isEqualWithoutRevision(QName other) {
        return this.localName.equals(other.getLocalName()) && Objects.equals(this.namespace, other.getNamespace());
    }
}

