/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.containermanager.northbound;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.ContainerConfig;
import org.opendaylight.controller.containermanager.ContainerFlowConfig;
import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.containermanager.northbound.ContainerConfigs;
import org.opendaylight.controller.containermanager.northbound.FlowSpecConfigs;
import org.opendaylight.controller.containermanager.northbound.StringList;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ResourceForbiddenException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.usermanager.IUserManager;

@Path(value="/")
public class ContainerManagerNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private IContainerManager getContainerManager() {
        IContainerManager containerMgr = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerMgr == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString());
        }
        return containerMgr;
    }

    private void handleNameMismatch(String name, String nameinURL) {
        if (name == null || nameinURL == null) {
            throw new BadRequestException(RestMessages.INVALIDJSON.toString());
        }
        if (name.equalsIgnoreCase(nameinURL)) {
            return;
        }
        throw new BadRequestException(RestMessages.INVALIDJSON.toString());
    }

    @Path(value="/containers")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=ContainerConfigs.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User is not authorized to perform this operation"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public ContainerConfigs viewAllContainers() {
        this.handleNetworkAuthorization(this.getUserName());
        IContainerManager containerManager = this.getContainerManager();
        return new ContainerConfigs(containerManager.getContainerConfigList());
    }

    @Path(value="/container/{container}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=ContainerConfig.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User is not authorized to perform this operation"), @ResponseCode(code=403, condition="Operation forbidden on default"), @ResponseCode(code=404, condition="The container is not found")})
    public ContainerConfigs viewContainer(@PathParam(value="container") String container) {
        this.handleContainerAuthorization(container, this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        ArrayList<ContainerConfig> containerConfigs = new ArrayList<ContainerConfig>();
        containerConfigs.add(containerManager.getContainerConfig(container));
        return new ContainerConfigs(containerConfigs);
    }

    @Path(value="/container/{container}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Container created successfully"), @ResponseCode(code=400, condition="Invalid Container configuration."), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=403, condition="Operation forbidden on default"), @ResponseCode(code=404, condition="Container Name is not found"), @ResponseCode(code=409, condition="Failed to create Container due to Conflicting Name"), @ResponseCode(code=500, condition="Failure Reason included in HTTP Error response")})
    public Response createContainer(@Context UriInfo uriInfo, @PathParam(value="container") String container, @TypeHint(value=ContainerConfig.class) ContainerConfig containerConfig) {
        this.handleAdminAuthorization(this.getUserName());
        this.handleContainerExists(container);
        this.handleNameMismatch(containerConfig.getContainerName(), container);
        this.handleForbiddenOnDefault(container);
        IContainerManager containerManager = this.getContainerManager();
        Status status = containerManager.addContainer(containerConfig);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Container", (String)this.username, (String)"added", (String)container);
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/container/{container}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="Container deleted successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=403, condition="Operation forbidden on default"), @ResponseCode(code=404, condition="The container is not found")})
    public Response removeContainer(@PathParam(value="container") String container) {
        this.handleAdminAuthorization(this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        Status status = containerManager.removeContainer(container);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Container", (String)this.username, (String)"removed", (String)container);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/container/{container}/flowspec/{flowspec}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=ContainerFlowConfig.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The container is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public ContainerFlowConfig viewContainerFlowSpec(@PathParam(value="container") String container, @PathParam(value="flowspec") String flowspec) {
        this.handleContainerAuthorization(container, this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        List flowSpecs = containerManager.getContainerFlows(container);
        for (ContainerFlowConfig containerFlowConfig : flowSpecs) {
            if (!containerFlowConfig.equalsByName(flowspec)) continue;
            return containerFlowConfig;
        }
        throw new ResourceNotFoundException("Flow Spec not found");
    }

    @Path(value="/container/{container}/flowspecs")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=FlowSpecConfigs.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The container is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public FlowSpecConfigs viewContainerFlowSpecs(@PathParam(value="container") String container) {
        this.handleContainerAuthorization(container, this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        return new FlowSpecConfigs(containerManager.getContainerFlows(container));
    }

    @Path(value="/container/{container}/flowspec/{flowspec}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="FlowSpec created successfully"), @ResponseCode(code=400, condition="Invalid flowspec configuration"), @ResponseCode(code=404, condition="The container is not found"), @ResponseCode(code=409, condition="Container Entry already exists"), @ResponseCode(code=500, condition="Failed to create Flow specifications. Failure Reason included in HTTP Error response")})
    public Response createFlowSpec(@Context UriInfo uriInfo, @PathParam(value="container") String container, @PathParam(value="flowspec") String flowspec, @TypeHint(value=ContainerFlowConfig.class) ContainerFlowConfig containerFlowConfig) {
        this.handleAdminAuthorization(this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        this.handleNameMismatch(containerFlowConfig.getName(), flowspec);
        IContainerManager containerManager = this.getContainerManager();
        ArrayList<ContainerFlowConfig> list = new ArrayList<ContainerFlowConfig>();
        list.add(containerFlowConfig);
        Status status = containerManager.addContainerFlows(container, list);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Flow Spec", (String)this.username, (String)"added", (String)containerFlowConfig.getName());
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/container/{container}/flowspec/{flowspec}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="Flow Spec deleted successfully"), @ResponseCode(code=400, condition="Invalid flowspec configuration"), @ResponseCode(code=404, condition="Container or Container Entry not found"), @ResponseCode(code=406, condition="Cannot operate on Default Container when other Containers are active"), @ResponseCode(code=500, condition="Failed to delete Flowspec. Failure Reason included in HTTP Error response"), @ResponseCode(code=503, condition="One or more of Controller service is unavailable")})
    public Response removeFlowSpec(@PathParam(value="container") String container, @PathParam(value="flowspec") String flowspec) {
        this.handleAdminAuthorization(this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        HashSet<String> set = new HashSet<String>();
        set.add(flowspec);
        Status status = containerManager.removeContainerFlows(container, set);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Flow Spec", (String)this.username, (String)"added", (String)flowspec);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/container/{container}/nodeconnector/")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @TypeHint(value=Response.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="NodeConnectors added successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=403, condition="Operation forbidden on default"), @ResponseCode(code=404, condition="The Container is not found"), @ResponseCode(code=409, condition="Container Entry already exists"), @ResponseCode(code=500, condition="Failed to create nodeconnectors. Failure Reason included in HTTP Error response")})
    public Response addNodeConnectors(@PathParam(value="container") String container, @TypeHint(value=StringList.class) StringList list) {
        this.handleAdminAuthorization(this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        Status status = containerManager.addContainerEntry(container, list.getList());
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Node ", (String)this.username, (String)"added", (String)(" Ports:" + list.getList()));
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/container/{container}/nodeconnector/")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=204, condition="Container Entry deleted successfully"), @ResponseCode(code=400, condition="Invalid Container Entry configuration"), @ResponseCode(code=404, condition="The Container is not found"), @ResponseCode(code=406, condition="Cannot operate on Default Container when other Containers are active"), @ResponseCode(code=500, condition="Failed to delete node connector. Failure Reason included in HTTP Error response")})
    public Response removeNodeConnectors(@PathParam(value="container") String container, @TypeHint(value=StringList.class) StringList portList) {
        this.handleAdminAuthorization(this.getUserName());
        this.handleForbiddenOnDefault(container);
        this.handleContainerNotExists(container);
        IContainerManager containerManager = this.getContainerManager();
        Status status = containerManager.removeContainerEntry(container, portList.getList());
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Node", (String)this.username, (String)"removed", (String)(" Ports:" + portList.getList()));
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    private void handleForbiddenOnDefault(String container) {
        if (container.equalsIgnoreCase(GlobalConstants.DEFAULT.toString())) {
            throw new ResourceForbiddenException(RestMessages.NODEFAULT.toString() + ": " + container);
        }
    }

    private void handleContainerNotExists(String container) {
        IContainerManager containerManager = this.getContainerManager();
        if (!containerManager.doesContainerExist(container)) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString() + ": " + container);
        }
    }

    private void handleContainerExists(String container) {
        IContainerManager containerManager = this.getContainerManager();
        if (containerManager.doesContainerExist(container)) {
            throw new ResourceConflictException(RestMessages.RESOURCECONFLICT.toString() + ": " + container);
        }
    }

    private void handleAdminAuthorization(String userName) {
        IUserManager usrMgr = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        UserLevel level = usrMgr.getUserLevel(userName);
        if (level.ordinal() <= UserLevel.NETWORKADMIN.ordinal()) {
            return;
        }
        throw new UnauthorizedException("User is not authorized to perform this operation");
    }

    private void handleNetworkAuthorization(String userName) {
        IUserManager usrMgr = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        UserLevel level = usrMgr.getUserLevel(userName);
        if (level.ordinal() <= UserLevel.NETWORKOPERATOR.ordinal()) {
            return;
        }
        throw new UnauthorizedException("User is not authorized to perform this operation");
    }

    private void handleContainerAuthorization(String container, String userName) {
        Privilege current;
        IContainerAuthorization auth = (IContainerAuthorization)ServiceHelper.getGlobalInstance(IContainerAuthorization.class, (Object)this);
        UserLevel level = auth.getUserLevel(userName);
        if (level.ordinal() <= UserLevel.NETWORKOPERATOR.ordinal()) {
            return;
        }
        Privilege privilege = current = auth == null ? Privilege.NONE : auth.getResourcePrivilege(userName, (Object)container);
        if (current.ordinal() > Privilege.NONE.ordinal()) {
            return;
        }
        throw new UnauthorizedException("User is not authorized to perform this operation");
    }
}

