/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.inventory.rev140108;

import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.inventory.rev140108.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.inventory.rev140108.NetconfNodeFields;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfNodeBuilder {
    private Boolean _connected;
    private List<String> _currentCapability;
    private List<String> _initialCapability;

    public NetconfNodeBuilder() {
    }

    public NetconfNodeBuilder(NetconfNodeFields arg) {
        this._connected = arg.isConnected();
        this._currentCapability = arg.getCurrentCapability();
        this._initialCapability = arg.getInitialCapability();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NetconfNodeFields) {
            this._connected = ((NetconfNodeFields)arg).isConnected();
            this._currentCapability = ((NetconfNodeFields)arg).getCurrentCapability();
            this._initialCapability = ((NetconfNodeFields)arg).getInitialCapability();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.inventory.rev140108.NetconfNodeFields] \nbut was: " + arg);
        }
    }

    public Boolean isConnected() {
        return this._connected;
    }

    public List<String> getCurrentCapability() {
        return this._currentCapability;
    }

    public List<String> getInitialCapability() {
        return this._initialCapability;
    }

    public NetconfNodeBuilder setConnected(Boolean value) {
        this._connected = value;
        return this;
    }

    public NetconfNodeBuilder setCurrentCapability(List<String> value) {
        this._currentCapability = value;
        return this;
    }

    public NetconfNodeBuilder setInitialCapability(List<String> value) {
        this._initialCapability = value;
        return this;
    }

    public NetconfNode build() {
        return new NetconfNodeImpl(this);
    }

    private static final class NetconfNodeImpl
    implements NetconfNode {
        private final Boolean _connected;
        private final List<String> _currentCapability;
        private final List<String> _initialCapability;

        public Class<NetconfNode> getImplementedInterface() {
            return NetconfNode.class;
        }

        private NetconfNodeImpl(NetconfNodeBuilder builder) {
            this._connected = builder.isConnected();
            this._currentCapability = builder.getCurrentCapability();
            this._initialCapability = builder.getInitialCapability();
        }

        @Override
        public Boolean isConnected() {
            return this._connected;
        }

        @Override
        public List<String> getCurrentCapability() {
            return this._currentCapability;
        }

        @Override
        public List<String> getInitialCapability() {
            return this._initialCapability;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._connected == null ? 0 : this._connected.hashCode());
            result = 31 * result + (this._currentCapability == null ? 0 : this._currentCapability.hashCode());
            result = 31 * result + (this._initialCapability == null ? 0 : this._initialCapability.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetconfNodeImpl other = (NetconfNodeImpl)obj;
            if (this._connected == null ? other._connected != null : !this._connected.equals(other._connected)) {
                return false;
            }
            if (this._currentCapability == null ? other._currentCapability != null : !this._currentCapability.equals(other._currentCapability)) {
                return false;
            }
            return !(this._initialCapability == null ? other._initialCapability != null : !this._initialCapability.equals(other._initialCapability));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NetconfNode [_connected=");
            builder.append(this._connected);
            builder.append(", _currentCapability=");
            builder.append(this._currentCapability);
            builder.append(", _initialCapability=");
            builder.append(this._initialCapability);
            builder.append("]");
            return builder.toString();
        }
    }
}

