/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeUpdatedBuilder {
    private NodeRef _nodeRef;
    private NodeId _id;
    private List<NodeConnector> _nodeConnector;
    private Map<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>();

    public NodeUpdatedBuilder() {
    }

    public NodeUpdatedBuilder(Node arg) {
        this._id = arg.getId();
        this._nodeConnector = arg.getNodeConnector();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Node) {
            this._id = ((Node)arg).getId();
            this._nodeConnector = ((Node)arg).getNodeConnector();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node] \nbut was: " + arg);
        }
    }

    public NodeRef getNodeRef() {
        return this._nodeRef;
    }

    public NodeId getId() {
        return this._id;
    }

    public List<NodeConnector> getNodeConnector() {
        return this._nodeConnector;
    }

    public <E extends Augmentation<NodeUpdated>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeUpdatedBuilder setNodeRef(NodeRef value) {
        this._nodeRef = value;
        return this;
    }

    public NodeUpdatedBuilder setId(NodeId value) {
        this._id = value;
        return this;
    }

    public NodeUpdatedBuilder setNodeConnector(List<NodeConnector> value) {
        this._nodeConnector = value;
        return this;
    }

    public NodeUpdatedBuilder addAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType, Augmentation<NodeUpdated> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeUpdated build() {
        return new NodeUpdatedImpl(this);
    }

    private static final class NodeUpdatedImpl
    implements NodeUpdated {
        private final NodeRef _nodeRef;
        private final NodeId _id;
        private final List<NodeConnector> _nodeConnector;
        private Map<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>();

        public Class<NodeUpdated> getImplementedInterface() {
            return NodeUpdated.class;
        }

        private NodeUpdatedImpl(NodeUpdatedBuilder builder) {
            this._nodeRef = builder.getNodeRef();
            this._id = builder.getId();
            this._nodeConnector = builder.getNodeConnector();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public NodeRef getNodeRef() {
            return this._nodeRef;
        }

        @Override
        public NodeId getId() {
            return this._id;
        }

        @Override
        public List<NodeConnector> getNodeConnector() {
            return this._nodeConnector;
        }

        public <E extends Augmentation<NodeUpdated>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nodeRef == null ? 0 : this._nodeRef.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._nodeConnector == null ? 0 : this._nodeConnector.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeUpdatedImpl other = (NodeUpdatedImpl)obj;
            if (this._nodeRef == null ? other._nodeRef != null : !this._nodeRef.equals(other._nodeRef)) {
                return false;
            }
            if (this._id == null ? other._id != null : !this._id.equals((Object)other._id)) {
                return false;
            }
            if (this._nodeConnector == null ? other._nodeConnector != null : !this._nodeConnector.equals(other._nodeConnector)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NodeUpdated [_nodeRef=");
            builder.append(this._nodeRef);
            builder.append(", _id=");
            builder.append((Object)this._id);
            builder.append(", _nodeConnector=");
            builder.append(this._nodeConnector);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

