/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.config.rev130819.nodes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.config.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.config.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder {
    private NodeKey _key;
    private NodeId _id;
    private List<NodeConnector> _nodeConnector;
    private Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();

    public NodeBuilder() {
    }

    public NodeBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node arg) {
        this._id = arg.getId();
        this._nodeConnector = arg.getNodeConnector();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node) {
            this._id = ((org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node)arg).getId();
            this._nodeConnector = ((org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node)arg).getNodeConnector();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node] \nbut was: " + arg);
        }
    }

    public NodeKey getKey() {
        return this._key;
    }

    public NodeId getId() {
        return this._id;
    }

    public List<NodeConnector> getNodeConnector() {
        return this._nodeConnector;
    }

    public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeBuilder setKey(NodeKey value) {
        this._key = value;
        return this;
    }

    public NodeBuilder setId(NodeId value) {
        this._id = value;
        return this;
    }

    public NodeBuilder setNodeConnector(List<NodeConnector> value) {
        this._nodeConnector = value;
        return this;
    }

    public NodeBuilder addAugmentation(Class<? extends Augmentation<Node>> augmentationType, Augmentation<Node> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    implements Node {
        private final NodeKey _key;
        private final NodeId _id;
        private final List<NodeConnector> _nodeConnector;
        private Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();

        public Class<Node> getImplementedInterface() {
            return Node.class;
        }

        private NodeImpl(NodeBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new NodeKey(builder.getId());
                this._id = builder.getId();
            } else {
                this._key = builder.getKey();
                this._id = this._key.getId();
            }
            this._nodeConnector = builder.getNodeConnector();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public NodeKey getKey() {
            return this._key;
        }

        @Override
        public NodeId getId() {
            return this._id;
        }

        @Override
        public List<NodeConnector> getNodeConnector() {
            return this._nodeConnector;
        }

        public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._nodeConnector == null ? 0 : this._nodeConnector.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeImpl other = (NodeImpl)obj;
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._id == null ? other._id != null : !this._id.equals((Object)other._id)) {
                return false;
            }
            if (this._nodeConnector == null ? other._nodeConnector != null : !this._nodeConnector.equals(other._nodeConnector)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Node [_key=");
            builder.append(this._key);
            builder.append(", _id=");
            builder.append((Object)this._id);
            builder.append(", _nodeConnector=");
            builder.append(this._nodeConnector);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

