/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.config.rev130819;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.config.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.config.rev130819.nodes.Node;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NodesBuilder {
    private List<Node> _node;
    private Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>();

    public List<Node> getNode() {
        return this._node;
    }

    public <E extends Augmentation<Nodes>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodesBuilder setNode(List<Node> value) {
        this._node = value;
        return this;
    }

    public NodesBuilder addAugmentation(Class<? extends Augmentation<Nodes>> augmentationType, Augmentation<Nodes> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Nodes build() {
        return new NodesImpl(this);
    }

    private static final class NodesImpl
    implements Nodes {
        private final List<Node> _node;
        private Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>();

        public Class<Nodes> getImplementedInterface() {
            return Nodes.class;
        }

        private NodesImpl(NodesBuilder builder) {
            this._node = builder.getNode();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        public <E extends Augmentation<Nodes>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodesImpl other = (NodesImpl)obj;
            if (this._node == null ? other._node != null : !this._node.equals(other._node)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Nodes [_node=");
            builder.append(this._node);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

