/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwarding.staticrouting.northbound;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.forwarding.staticrouting.IForwardingStaticRouting;
import org.opendaylight.controller.forwarding.staticrouting.StaticRouteConfig;
import org.opendaylight.controller.forwarding.staticrouting.northbound.StaticRoute;
import org.opendaylight.controller.forwarding.staticrouting.northbound.StaticRoutes;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.NotAcceptableException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;

@Path(value="/")
public class StaticRoutingNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private List<StaticRoute> getStaticRoutesInternal(String containerName) {
        IForwardingStaticRouting staticRouting = (IForwardingStaticRouting)ServiceHelper.getInstance(IForwardingStaticRouting.class, (String)containerName, (Object)this);
        if (staticRouting == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        ArrayList<StaticRoute> routes = new ArrayList<StaticRoute>();
        for (StaticRouteConfig conf : staticRouting.getStaticRouteConfigs().values()) {
            StaticRoute route = new StaticRoute(conf.getName(), conf.getStaticRoute(), conf.getNextHop());
            routes.add(route);
        }
        return routes;
    }

    @Path(value="/{containerName}/routes")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=StaticRoutes.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName passed was not found")})
    public StaticRoutes getStaticRoutes(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        return new StaticRoutes(this.getStaticRoutesInternal(containerName));
    }

    @Path(value="/{containerName}/route/{route}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=StaticRoute.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The Container Name or Static Route Configuration name passed was not found")})
    public StaticRoute getStaticRoute(@PathParam(value="containerName") String containerName, @PathParam(value="route") String route) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        List<StaticRoute> routes = this.getStaticRoutesInternal(containerName);
        for (StaticRoute r : routes) {
            if (!r.getName().equalsIgnoreCase(route)) continue;
            return r;
        }
        throw new ResourceNotFoundException(RestMessages.NOSTATICROUTE.toString());
    }

    @Path(value="/{containerName}/route/{route}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Created Static Route successfully"), @ResponseCode(code=404, condition="The Container Name passed is not found"), @ResponseCode(code=406, condition="Cannot operate on Default Container when other Containers are active"), @ResponseCode(code=409, condition="Failed to create Static Route entry due to Conflicting Name or Prefix.")})
    public Response addStaticRoute(@Context UriInfo uriInfo, @PathParam(value="containerName") String containerName, @PathParam(value="route") String route, @TypeHint(value=StaticRoute.class) StaticRoute staticRouteData) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IForwardingStaticRouting staticRouting = (IForwardingStaticRouting)ServiceHelper.getInstance(IForwardingStaticRouting.class, (String)containerName, (Object)this);
        if (staticRouting == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        StaticRoute sRoute = staticRouteData;
        StaticRouteConfig cfgObject = new StaticRouteConfig(sRoute.getName(), sRoute.getPrefix(), sRoute.getNextHop());
        Status response = staticRouting.addStaticRoute(cfgObject);
        if (response.isSuccess()) {
            NorthboundUtils.auditlog((String)"Static Route", (String)this.username, (String)"added", (String)route, (String)containerName);
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        throw new ResourceConflictException(response.getDescription());
    }

    @Path(value="/{containerName}/route/{route}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="Static route removed successfully"), @ResponseCode(code=404, condition="Container Name or Configuration Name not found"), @ResponseCode(code=406, condition="Cannot operate on Default Container when other Containers are active")})
    public Response removeStaticRoute(@PathParam(value="containerName") String containerName, @PathParam(value="route") String route) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IForwardingStaticRouting staticRouting = (IForwardingStaticRouting)ServiceHelper.getInstance(IForwardingStaticRouting.class, (String)containerName, (Object)this);
        if (staticRouting == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        Status status = staticRouting.removeStaticRoute(route);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Static Route", (String)this.username, (String)"removed", (String)route, (String)containerName);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    private void handleDefaultDisabled(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString());
        }
        if (containerName.equals(GlobalConstants.DEFAULT.toString()) && containerManager.hasNonDefaultContainer()) {
            throw new NotAcceptableException(RestMessages.DEFAULTDISABLED.toString());
        }
    }
}

