/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

public class ModuleQNameUtil {
    public static Set<String> getQNames(Map<String, Map.Entry<ModuleFactory, BundleContext>> resolved) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<ModuleFactory, BundleContext> entry : resolved.values()) {
            Class<?> inspected = entry.getKey().getClass();
            if (inspected.isInterface()) {
                throw new IllegalArgumentException("Unexpected interface " + inspected);
            }
            ModuleQName annotation = null;
            while (annotation == null && inspected != null) {
                annotation = inspected.getAnnotation(ModuleQName.class);
                inspected = inspected.getSuperclass();
            }
            if (annotation == null) continue;
            String qName = "(" + annotation.namespace() + "?revision=" + annotation.revision() + ")" + annotation.name();
            result.add(qName);
        }
        return result;
    }
}

