/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMX;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;

public class InterfacesHelper {
    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException(clazz + " should not be an interface");
        }
        HashSet toBeInspected = new HashSet();
        while (!clazz.equals(Object.class)) {
            toBeInspected.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return InterfacesHelper.getAllSuperInterfaces(toBeInspected);
    }

    private static Set<Class<?>> getAllSuperInterfaces(Set<Class<?>> ifcs) {
        ifcs = new HashSet(ifcs);
        HashSet result = new HashSet();
        while (ifcs.size() > 0) {
            Iterator<Class<?>> iterator = ifcs.iterator();
            Class<?> ifc = iterator.next();
            iterator.remove();
            if (!ifc.isInterface()) {
                throw new IllegalArgumentException(ifc + " should be an interface");
            }
            ifcs.addAll(Arrays.asList(ifc.getInterfaces()));
            result.add(ifc);
        }
        return result;
    }

    public static Set<Class<?>> getMXInterfaces(Class<? extends Module> configBeanClass) {
        Set<Class<?>> allInterfaces = InterfacesHelper.getAllInterfaces(configBeanClass);
        HashSet result = new HashSet();
        for (Class<?> clazz : allInterfaces) {
            if (!JMX.isMXBeanInterface(clazz)) continue;
            result.add(clazz);
        }
        return result;
    }

    public static Set<Class<?>> getServiceInterfaces(Class<? extends Module> configBeanClass) {
        Set<Class<?>> allInterfaces = InterfacesHelper.getAllInterfaces(configBeanClass);
        HashSet result = new HashSet();
        for (Class<?> clazz : allInterfaces) {
            ServiceInterfaceAnnotation annotation;
            if (!AbstractServiceInterface.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(ServiceInterfaceAnnotation.class)) == null) continue;
            result.add(clazz);
        }
        return result;
    }

    public static Set<Class<? extends AbstractServiceInterface>> getAllAbstractServiceClasses(Class<? extends Module> configBeanClass) {
        HashSet<Class<? extends AbstractServiceInterface>> foundGeneratedSIClasses = new HashSet<Class<? extends AbstractServiceInterface>>();
        for (Class<?> clazz : InterfacesHelper.getAllInterfaces(configBeanClass)) {
            if (!AbstractServiceInterface.class.isAssignableFrom(clazz) || AbstractServiceInterface.class.equals(clazz)) continue;
            foundGeneratedSIClasses.add(clazz);
        }
        return InterfacesHelper.getAllAbstractServiceInterfaceClasses(foundGeneratedSIClasses);
    }

    public static Set<Class<?>> getOsgiRegistrationTypes(Class<? extends Module> configBeanClass) {
        Set<Class<?>> serviceInterfaces = InterfacesHelper.getServiceInterfaces(configBeanClass);
        HashSet result = new HashSet();
        for (Class<?> clazz : serviceInterfaces) {
            ServiceInterfaceAnnotation annotation = clazz.getAnnotation(ServiceInterfaceAnnotation.class);
            result.add(annotation.osgiRegistrationType());
        }
        return result;
    }

    public static Set<ServiceInterfaceAnnotation> getServiceInterfaceAnnotations(ModuleFactory factory) {
        Set<Class<? extends AbstractServiceInterface>> implementedServiceIntefaces = Collections.unmodifiableSet(factory.getImplementedServiceIntefaces());
        return InterfacesHelper.getServiceInterfaceAnnotations(implementedServiceIntefaces);
    }

    private static Set<ServiceInterfaceAnnotation> getServiceInterfaceAnnotations(Set<Class<? extends AbstractServiceInterface>> implementedServiceIntefaces) {
        Set<Class<? extends AbstractServiceInterface>> inspected = InterfacesHelper.getAllAbstractServiceInterfaceClasses(implementedServiceIntefaces);
        HashSet<ServiceInterfaceAnnotation> result = new HashSet<ServiceInterfaceAnnotation>();
        for (Class<? extends AbstractServiceInterface> clazz : inspected) {
            ServiceInterfaceAnnotation annotation = clazz.getAnnotation(ServiceInterfaceAnnotation.class);
            if (annotation == null) continue;
            result.add(annotation);
        }
        return result;
    }

    static Set<Class<? extends AbstractServiceInterface>> getAllAbstractServiceInterfaceClasses(Set<Class<? extends AbstractServiceInterface>> directlyImplementedAbstractSIs) {
        Set<Class<?>> allInterfaces = InterfacesHelper.getAllSuperInterfaces(directlyImplementedAbstractSIs);
        HashSet<Class<? extends AbstractServiceInterface>> result = new HashSet<Class<? extends AbstractServiceInterface>>();
        for (Class<?> ifc : allInterfaces) {
            if (!AbstractServiceInterface.class.isAssignableFrom(ifc) || ifc.equals(AbstractServiceInterface.class)) continue;
            result.add(ifc);
        }
        return result;
    }
}

