/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opendaylight.controller.config.manager.impl.osgi.BlankTransactionServiceTracker;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtenderBundleTracker
extends BundleTracker<Object> {
    private final BlankTransactionServiceTracker blankTransactionServiceTracker;
    private static final Logger logger = LoggerFactory.getLogger(ExtenderBundleTracker.class);

    public ExtenderBundleTracker(BundleContext context, BlankTransactionServiceTracker blankTransactionServiceTracker) {
        super(context, 32, null);
        this.blankTransactionServiceTracker = blankTransactionServiceTracker;
        logger.trace("Registered as extender with context {}", (Object)context);
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        URL resource = bundle.getEntry("META-INF/services/" + ModuleFactory.class.getName());
        logger.trace("Got addingBundle event of bundle {}, resource {}, event {}", new Object[]{bundle, resource, event});
        if (resource != null) {
            try (InputStream inputStream = resource.openStream();){
                List lines = IOUtils.readLines((InputStream)inputStream);
                for (String factoryClassName : lines) {
                    ExtenderBundleTracker.registerFactory(factoryClassName, bundle);
                }
            }
            catch (Exception e) {
                logger.error("Error while reading {}", (Object)resource, (Object)e);
                throw new RuntimeException(e);
            }
        }
        return bundle;
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        super.removedBundle(bundle, event, object);
        this.blankTransactionServiceTracker.blankTransaction();
    }

    private static ServiceRegistration<?> registerFactory(String factoryClassName, Bundle bundle) {
        String errorMessage;
        block6: {
            try {
                Class clazz = bundle.loadClass(factoryClassName);
                if (ModuleFactory.class.isAssignableFrom(clazz)) {
                    try {
                        logger.debug("Registering {} in bundle {}", (Object)clazz.getName(), (Object)bundle);
                        return bundle.getBundleContext().registerService(ModuleFactory.class.getName(), clazz.newInstance(), null);
                    }
                    catch (InstantiationException e) {
                        errorMessage = ExtenderBundleTracker.logMessage("Could not instantiate {} in bundle {}, reason {}", factoryClassName, bundle, e);
                        break block6;
                    }
                    catch (IllegalAccessException e) {
                        errorMessage = ExtenderBundleTracker.logMessage("Illegal access during instatiation of class {} in bundle {}, reason {}", factoryClassName, bundle, e);
                        break block6;
                    }
                }
                errorMessage = ExtenderBundleTracker.logMessage("Class {} does not implement {} in bundle {}", clazz, ModuleFactory.class, bundle);
            }
            catch (ClassNotFoundException e) {
                errorMessage = ExtenderBundleTracker.logMessage("Could not find class {} in bunde {}, reason {}", factoryClassName, bundle, e);
            }
        }
        throw new IllegalStateException(errorMessage);
    }

    public static String logMessage(String slfMessage, Object ... params) {
        logger.info(slfMessage, params);
        String formatMessage = slfMessage.replaceAll("\\{\\}", "%s");
        return String.format(formatMessage, params);
    }
}

