/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImpl;
import org.opendaylight.controller.config.manager.impl.jmx.ConfigRegistryJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.osgi.BindingIndependentMappingServiceTracker;
import org.opendaylight.controller.config.manager.impl.osgi.BlankTransactionServiceTracker;
import org.opendaylight.controller.config.manager.impl.osgi.BundleContextBackedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.osgi.ExtenderBundleTracker;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManagerActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManagerActivator.class);
    private ExtenderBundleTracker extenderBundleTracker;
    private ConfigRegistryImpl configRegistry;
    private ConfigRegistryJMXRegistrator configRegistryJMXRegistrator;
    private ServiceRegistration configRegistryServiceRegistration;
    private ServiceTracker<BindingIndependentMappingService, BindingIndependentMappingService> tracker;

    public void start(BundleContext context) throws Exception {
        BindingIndependentMappingServiceTracker mappingServiceTracker = new BindingIndependentMappingServiceTracker(context, this);
        this.tracker = new ServiceTracker(context, BindingIndependentMappingService.class, (ServiceTrackerCustomizer)mappingServiceTracker);
        logger.debug("Waiting for codec registry");
        this.tracker.open();
    }

    void initConfigManager(BundleContext context, CodecRegistry codecRegistry) {
        BundleContextBackedModuleFactoriesResolver bundleContextBackedModuleFactoriesResolver = new BundleContextBackedModuleFactoriesResolver(context);
        MBeanServer configMBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.configRegistry = new ConfigRegistryImpl(bundleContextBackedModuleFactoriesResolver, configMBeanServer, codecRegistry);
        this.configRegistryServiceRegistration = context.registerService(ConfigRegistryImpl.class, (Object)this.configRegistry, null);
        this.configRegistryJMXRegistrator = new ConfigRegistryJMXRegistrator(configMBeanServer);
        try {
            this.configRegistryJMXRegistrator.registerToJMX(this.configRegistry);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException("Config Registry was already registered to JMX", e);
        }
        BlankTransactionServiceTracker blankTransactionServiceTracker = new BlankTransactionServiceTracker(this.configRegistry);
        this.extenderBundleTracker = new ExtenderBundleTracker(context, blankTransactionServiceTracker);
        this.extenderBundleTracker.open();
        ServiceTracker serviceTracker = new ServiceTracker(context, ModuleFactory.class, (ServiceTrackerCustomizer)blankTransactionServiceTracker);
        serviceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.tracker.close();
        }
        catch (Exception e) {
            logger.warn("Exception while closing tracker", (Throwable)e);
        }
        try {
            this.configRegistry.close();
        }
        catch (Exception e) {
            logger.warn("Exception while closing config registry", (Throwable)e);
        }
        try {
            this.extenderBundleTracker.close();
        }
        catch (Exception e) {
            logger.warn("Exception while closing extender", (Throwable)e);
        }
        try {
            this.configRegistryJMXRegistrator.close();
        }
        catch (Exception e) {
            logger.warn("Exception while closing config registry jmx registrator", (Throwable)e);
        }
        try {
            this.configRegistryServiceRegistration.unregister();
        }
        catch (Exception e) {
            logger.warn("Exception while unregistering config registry", (Throwable)e);
        }
    }
}

