/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextBackedModuleFactoriesResolver
implements ModuleFactoriesResolver {
    private static final Logger logger = LoggerFactory.getLogger(BundleContextBackedModuleFactoriesResolver.class);
    private final BundleContext bundleContext;

    public BundleContextBackedModuleFactoriesResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Map<String, Map.Entry<ModuleFactory, BundleContext>> getAllFactories() {
        Collection serviceReferences;
        try {
            serviceReferences = this.bundleContext.getServiceReferences(ModuleFactory.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        HashMap<String, Map.Entry<ModuleFactory, BundleContext>> result = new HashMap<String, Map.Entry<ModuleFactory, BundleContext>>(serviceReferences.size());
        for (ServiceReference serviceReference : serviceReferences) {
            ModuleFactory factory = (ModuleFactory)this.bundleContext.getService(serviceReference);
            if (factory == null) {
                throw new NullPointerException("ServiceReference of class" + serviceReference.getClass() + "not found.");
            }
            StringBuffer errors = new StringBuffer();
            String moduleName = factory.getImplementationName();
            if (moduleName == null || moduleName.isEmpty()) {
                throw new IllegalStateException("Invalid implementation name for " + factory);
            }
            if (serviceReference.getBundle() == null || serviceReference.getBundle().getBundleContext() == null) {
                throw new NullPointerException("Bundle context of " + factory + " ModuleFactory not found.");
            }
            logger.debug("Reading factory {} {}", (Object)moduleName, (Object)factory);
            String error = null;
            Map.Entry conflicting = (Map.Entry)result.get(moduleName);
            if (conflicting != null) {
                error = String.format("Module name is not unique. Found two conflicting factories with same name '%s': \n\t%s\n\t%s\n", moduleName, conflicting.getKey(), factory);
            }
            if (error == null) {
                result.put(moduleName, new AbstractMap.SimpleImmutableEntry<ModuleFactory, BundleContext>(factory, serviceReference.getBundle().getBundleContext()));
            } else {
                errors.append(error);
            }
            if (errors.length() <= 0) continue;
            throw new IllegalArgumentException(errors.toString());
        }
        return result;
    }
}

