/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImpl;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlankTransactionServiceTracker
implements ServiceTrackerCustomizer<ModuleFactory, Object> {
    private static final Logger logger = LoggerFactory.getLogger(BlankTransactionServiceTracker.class);
    private final ConfigRegistryImpl configRegistry;

    public BlankTransactionServiceTracker(ConfigRegistryImpl configRegistry) {
        this.configRegistry = configRegistry;
    }

    public Object addingService(ServiceReference<ModuleFactory> moduleFactoryServiceReference) {
        this.blankTransaction();
        return null;
    }

    synchronized void blankTransaction() {
        ConflictingVersionException lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                boolean blankTransaction = true;
                ObjectName tx = this.configRegistry.beginConfig(blankTransaction);
                CommitStatus commitStatus = this.configRegistry.commitConfig(tx);
                logger.debug("Committed blank transaction with status {}", (Object)commitStatus);
                return;
            }
            catch (ConflictingVersionException e) {
                lastException = e;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(interruptedException);
                }
            }
        }
        throw lastException;
    }

    public void modifiedService(ServiceReference<ModuleFactory> moduleFactoryServiceReference, Object o) {
        this.blankTransaction();
    }

    public void removedService(ServiceReference<ModuleFactory> moduleFactoryServiceReference, Object o) {
        this.blankTransaction();
    }
}

