/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import org.opendaylight.controller.config.manager.impl.osgi.ConfigManagerActivator;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingIndependentMappingServiceTracker
implements ServiceTrackerCustomizer<BindingIndependentMappingService, BindingIndependentMappingService> {
    private static final Logger logger = LoggerFactory.getLogger(BindingIndependentMappingServiceTracker.class);
    private final ConfigManagerActivator activator;
    private final BundleContext ctx;
    private BindingIndependentMappingService service;

    public BindingIndependentMappingServiceTracker(BundleContext context, ConfigManagerActivator activator) {
        this.ctx = context;
        this.activator = activator;
    }

    public synchronized BindingIndependentMappingService addingService(ServiceReference<BindingIndependentMappingService> moduleFactoryServiceReference) {
        BindingIndependentMappingService service;
        if (this.service != null) {
            logger.debug("BindingIndependentMappingService was already added as {} now added as {}", (Object)this.service, this.ctx.getService(moduleFactoryServiceReference));
            return null;
        }
        this.service = service = (BindingIndependentMappingService)this.ctx.getService(moduleFactoryServiceReference);
        CodecRegistry codecRegistry = service.getCodecRegistry();
        logger.warn("Codec registry acquired {}", (Object)codecRegistry);
        this.activator.initConfigManager(this.ctx, codecRegistry);
        return service;
    }

    public void modifiedService(ServiceReference<BindingIndependentMappingService> moduleFactoryServiceReference, BindingIndependentMappingService o) {
    }

    public void removedService(ServiceReference<BindingIndependentMappingService> moduleFactoryServiceReference, BindingIndependentMappingService o) {
    }
}

