/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.manager.impl.util.InterfacesHelper;
import org.opendaylight.controller.config.spi.Module;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class BeanToOsgiServiceManager {
    static final String INSTANCE_NAME_OSGI_PROP = "instanceName";
    static final String IMPLEMENTATION_NAME_OSGI_PROP = "implementationName";

    public OsgiRegistration registerToOsgi(Class<? extends Module> configBeanClass, AutoCloseable instance, ModuleIdentifier moduleIdentifier, BundleContext bundleContext) {
        try {
            Set<Class<?>> configuresInterfaces = InterfacesHelper.getOsgiRegistrationTypes(configBeanClass);
            this.checkInstanceImplementing(instance, configuresInterfaces);
            if (!configuresInterfaces.isEmpty()) {
                Dictionary<String, ?> propertiesForOsgi = BeanToOsgiServiceManager.getPropertiesForOsgi(moduleIdentifier);
                ServiceRegistration serviceRegistration = bundleContext.registerService(BeanToOsgiServiceManager.classesToNames(configuresInterfaces), (Object)instance, propertiesForOsgi);
                return new OsgiRegistration(serviceRegistration);
            }
            return new OsgiRegistration();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Error while registering instance into OSGi Service Registry: " + moduleIdentifier, e);
        }
    }

    private static String[] classesToNames(Set<Class<?>> cfgs) {
        String[] result = new String[cfgs.size()];
        int i = 0;
        for (Class<?> cfg : cfgs) {
            result[i] = cfg.getName();
            ++i;
        }
        return result;
    }

    private void checkInstanceImplementing(AutoCloseable instance, Set<Class<?>> configures) {
        HashSet missing = new HashSet();
        for (Class<?> requiredIfc : configures) {
            if (requiredIfc.isInstance(instance)) continue;
            missing.add(requiredIfc);
        }
        if (!missing.isEmpty()) {
            throw new IllegalStateException(instance.getClass() + " does not implement following interfaces as announced by " + ServiceInterfaceAnnotation.class.getName() + " annotation :" + missing);
        }
    }

    private static Dictionary<String, ?> getPropertiesForOsgi(ModuleIdentifier moduleIdentifier) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(IMPLEMENTATION_NAME_OSGI_PROP, moduleIdentifier.getFactoryName());
        table.put(INSTANCE_NAME_OSGI_PROP, moduleIdentifier.getInstanceName());
        return table;
    }

    public static class OsgiRegistration
    implements AutoCloseable {
        private final ServiceRegistration<?> serviceRegistration;

        public OsgiRegistration(ServiceRegistration<?> serviceRegistration) {
            this.serviceRegistration = serviceRegistration;
        }

        public OsgiRegistration() {
            this.serviceRegistration = null;
        }

        @Override
        public void close() {
            if (this.serviceRegistration != null) {
                this.serviceRegistration.unregister();
            }
        }
    }
}

