/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import java.io.Closeable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.jmx.InternalJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.NestableJMXRegistrator;

public class TransactionModuleJMXRegistrator
implements Closeable,
NestableJMXRegistrator {
    private final InternalJMXRegistrator currentJMXRegistrator;
    private final String transactionName;

    public TransactionModuleJMXRegistrator(InternalJMXRegistrator internalJMXRegistrator, String transactionName) {
        this.currentJMXRegistrator = internalJMXRegistrator.createChild();
        this.transactionName = transactionName;
    }

    public TransactionModuleJMXRegistration registerMBean(Object object, ObjectName on) throws InstanceAlreadyExistsException {
        if (!this.transactionName.equals(ObjectNameUtil.getTransactionName((ObjectName)on))) {
            throw new IllegalArgumentException("Transaction name mismatch between expected " + this.transactionName + " " + "and " + on);
        }
        ObjectNameUtil.checkTypeOneOf((ObjectName)on, (String[])new String[]{"Module"});
        return new TransactionModuleJMXRegistration(this.currentJMXRegistrator.registerMBean(object, on));
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.currentJMXRegistrator.queryNames(name, query);
    }

    @Override
    public void close() {
        this.currentJMXRegistrator.close();
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    @Override
    public InternalJMXRegistrator createChild() {
        return this.currentJMXRegistrator.createChild();
    }

    public static class TransactionModuleJMXRegistration
    implements AutoCloseable {
        private final InternalJMXRegistrator.InternalJMXRegistration registration;

        TransactionModuleJMXRegistration(InternalJMXRegistrator.InternalJMXRegistration registration) {
            this.registration = registration;
        }

        @Override
        public void close() {
            this.registration.close();
        }
    }
}

