/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import java.io.Closeable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.jmx.InternalJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;

public class TransactionJMXRegistrator
implements Closeable {
    private final InternalJMXRegistrator childJMXRegistrator;
    private final String transactionName;

    TransactionJMXRegistrator(InternalJMXRegistrator internalJMXRegistrator, String transactionName) {
        this.childJMXRegistrator = internalJMXRegistrator.createChild();
        this.transactionName = transactionName;
    }

    public TransactionJMXRegistration registerMBean(Object object, ObjectName on) throws InstanceAlreadyExistsException {
        if (!this.transactionName.equals(ObjectNameUtil.getTransactionName((ObjectName)on))) {
            throw new IllegalArgumentException("Transaction name mismatch between expected " + this.transactionName + " " + "and " + on);
        }
        ObjectNameUtil.checkType((ObjectName)on, (String)"ConfigTransaction");
        return new TransactionJMXRegistration(this.childJMXRegistrator.registerMBean(object, on));
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.childJMXRegistrator.queryNames(name, query);
    }

    public TransactionModuleJMXRegistrator createTransactionModuleJMXRegistrator() {
        return new TransactionModuleJMXRegistrator(this.childJMXRegistrator, this.transactionName);
    }

    @Override
    public void close() {
        this.childJMXRegistrator.close();
    }

    public static class TransactionJMXRegistration
    implements AutoCloseable {
        private final InternalJMXRegistrator.InternalJMXRegistration registration;

        TransactionJMXRegistration(InternalJMXRegistrator.InternalJMXRegistration registration) {
            this.registration = registration;
        }

        @Override
        public void close() {
            this.registration.close();
        }
    }
}

