/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.InternalJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.NestableJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.ServiceReferenceMXBeanImpl;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;

public interface ServiceReferenceRegistrator
extends AutoCloseable {
    public String getNullableTransactionName();

    public ServiceReferenceJMXRegistration registerMBean(ServiceReferenceMXBeanImpl var1, ObjectName var2) throws InstanceAlreadyExistsException;

    @Override
    public void close();

    public static class ServiceReferenceTransactionRegistratorFactoryImpl
    implements ServiceReferenceTransactionRegistratorFactory {
        private final NestableJMXRegistrator parentRegistrator;
        private final String nullableTransactionName;

        public ServiceReferenceTransactionRegistratorFactoryImpl(TransactionModuleJMXRegistrator parentRegistrator, String nullableTransactionName) {
            this.parentRegistrator = parentRegistrator;
            this.nullableTransactionName = nullableTransactionName;
        }

        public ServiceReferenceTransactionRegistratorFactoryImpl(BaseJMXRegistrator baseJMXRegistrator) {
            this.parentRegistrator = baseJMXRegistrator;
            this.nullableTransactionName = null;
        }

        @Override
        public ServiceReferenceRegistrator create() {
            return new ServiceReferenceRegistratorImpl(this.parentRegistrator, this.nullableTransactionName);
        }
    }

    public static class ServiceReferenceRegistratorImpl
    implements ServiceReferenceRegistrator {
        private final InternalJMXRegistrator currentJMXRegistrator;
        private final String nullableTransactionName;

        public ServiceReferenceRegistratorImpl(NestableJMXRegistrator parentRegistrator, String nullableTransactionName) {
            this.currentJMXRegistrator = parentRegistrator.createChild();
            this.nullableTransactionName = nullableTransactionName;
        }

        @Override
        public String getNullableTransactionName() {
            return this.nullableTransactionName;
        }

        @Override
        public ServiceReferenceJMXRegistration registerMBean(ServiceReferenceMXBeanImpl object, ObjectName on) throws InstanceAlreadyExistsException {
            String actualTransactionName = ObjectNameUtil.getTransactionName((ObjectName)on);
            boolean broken = false;
            broken |= this.nullableTransactionName == null != (actualTransactionName == null);
            if (broken |= this.nullableTransactionName != null && !this.nullableTransactionName.equals(actualTransactionName)) {
                throw new IllegalArgumentException("Transaction name mismatch between expected " + this.nullableTransactionName + ", got " + actualTransactionName + " in " + on);
            }
            if (!ObjectNameUtil.isServiceReference((ObjectName)on)) {
                throw new IllegalArgumentException("Invalid type of " + on);
            }
            return new ServiceReferenceJMXRegistration(this.currentJMXRegistrator.registerMBean(object, on));
        }

        @Override
        public void close() {
            this.currentJMXRegistrator.close();
        }

        public static interface ServiceReferenceTransactionRegistratorFactory {
            public ServiceReferenceRegistrator create();
        }
    }

    public static interface ServiceReferenceTransactionRegistratorFactory {
        public ServiceReferenceRegistrator create();
    }

    public static class ServiceReferenceJMXRegistration
    implements AutoCloseable {
        private final InternalJMXRegistrator.InternalJMXRegistration registration;

        ServiceReferenceJMXRegistration(InternalJMXRegistrator.InternalJMXRegistration registration) {
            this.registration = registration;
        }

        @Override
        public void close() {
            this.registration.close();
        }
    }
}

