/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import java.util.Collections;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.manager.impl.jmx.HierarchicalRuntimeBeanRegistrationImpl;
import org.opendaylight.controller.config.manager.impl.jmx.InternalJMXRegistrator;

public class RootRuntimeBeanRegistratorImpl
implements RootRuntimeBeanRegistrator {
    private final InternalJMXRegistrator internalJMXRegistrator;
    private final ModuleIdentifier moduleIdentifier;
    private final ObjectName defaultRuntimeON;

    public RootRuntimeBeanRegistratorImpl(InternalJMXRegistrator internalJMXRegistrator, ModuleIdentifier moduleIdentifier) {
        this.internalJMXRegistrator = internalJMXRegistrator;
        this.moduleIdentifier = moduleIdentifier;
        this.defaultRuntimeON = ObjectNameUtil.createRuntimeBeanName((String)moduleIdentifier.getFactoryName(), (String)moduleIdentifier.getInstanceName(), Collections.emptyMap());
    }

    public HierarchicalRuntimeBeanRegistrationImpl registerRoot(RuntimeBean mxBean) {
        try {
            this.internalJMXRegistrator.registerMBean(mxBean, this.defaultRuntimeON);
        }
        catch (InstanceAlreadyExistsException e) {
            throw RootRuntimeBeanRegistratorImpl.sanitize(e, this.moduleIdentifier, this.defaultRuntimeON);
        }
        return new HierarchicalRuntimeBeanRegistrationImpl(this.moduleIdentifier, this.internalJMXRegistrator, Collections.emptyMap());
    }

    public void close() {
        this.internalJMXRegistrator.close();
    }

    static IllegalStateException sanitize(InstanceAlreadyExistsException e, ModuleIdentifier moduleIdentifier, ObjectName on) {
        throw new IllegalStateException("Could not register runtime bean in " + moduleIdentifier + " under name " + on, e);
    }
}

