/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import java.io.Closeable;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.jmx.InternalJMXRegistrator;

@ThreadSafe
public class ModuleJMXRegistrator
implements Closeable {
    private final InternalJMXRegistrator childJMXRegistrator;

    public ModuleJMXRegistrator(InternalJMXRegistrator internalJMXRegistrator) {
        this.childJMXRegistrator = internalJMXRegistrator.createChild();
    }

    public ModuleJMXRegistration registerMBean(Object object, ObjectName on) throws InstanceAlreadyExistsException {
        ObjectNameUtil.checkType((ObjectName)on, (String)"Module");
        if (ObjectNameUtil.getTransactionName((ObjectName)on) != null) {
            throw new IllegalArgumentException("Transaction name not expected in " + on);
        }
        return new ModuleJMXRegistration(this.childJMXRegistrator.registerMBean(object, on));
    }

    @Override
    public void close() {
        this.childJMXRegistrator.close();
    }

    static class ModuleJMXRegistration
    implements AutoCloseable {
        private final InternalJMXRegistrator.InternalJMXRegistration internalJMXRegistration;

        ModuleJMXRegistration(InternalJMXRegistrator.InternalJMXRegistration registration) {
            this.internalJMXRegistration = registration;
        }

        @Override
        public void close() {
            this.internalJMXRegistration.close();
        }
    }
}

