/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalJMXRegistrator
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(InternalJMXRegistrator.class);
    private final MBeanServer configMBeanServer;
    @GuardedBy(value="this")
    private final Set<ObjectName> registeredObjectNames = new HashSet<ObjectName>();
    private final List<InternalJMXRegistrator> children = new ArrayList<InternalJMXRegistrator>();

    public InternalJMXRegistrator(MBeanServer configMBeanServer) {
        this.configMBeanServer = configMBeanServer;
    }

    public synchronized InternalJMXRegistration registerMBean(Object object, ObjectName on) throws InstanceAlreadyExistsException {
        try {
            this.configMBeanServer.registerMBean(object, on);
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.registeredObjectNames.add(on);
        return new InternalJMXRegistration(this, on);
    }

    private synchronized void unregisterMBean(ObjectName on) {
        boolean removed = this.registeredObjectNames.remove(on);
        if (!removed) {
            throw new IllegalStateException("Cannot unregister - ObjectName not found in 'registeredObjectNames': " + on);
        }
        try {
            this.configMBeanServer.unregisterMBean(on);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InternalJMXRegistrator createChild() {
        InternalJMXRegistrator child = new InternalJMXRegistrator(this.configMBeanServer);
        this.children.add(child);
        return child;
    }

    @Override
    public synchronized void close() {
        for (InternalJMXRegistrator child : this.children) {
            child.close();
        }
        for (ObjectName on : this.registeredObjectNames) {
            try {
                this.configMBeanServer.unregisterMBean(on);
            }
            catch (Exception e) {
                logger.warn("Ignoring error while unregistering {}", (Object)on, (Object)e);
            }
        }
        this.registeredObjectNames.clear();
    }

    public <T> T newMBeanProxy(ObjectName objectName, Class<T> interfaceClass) {
        return JMX.newMBeanProxy(this.configMBeanServer, objectName, interfaceClass);
    }

    public <T> T newMBeanProxy(ObjectName objectName, Class<T> interfaceClass, boolean notificationBroadcaster) {
        return JMX.newMBeanProxy(this.configMBeanServer, objectName, interfaceClass, notificationBroadcaster);
    }

    public <T> T newMXBeanProxy(ObjectName objectName, Class<T> interfaceClass) {
        return JMX.newMXBeanProxy(this.configMBeanServer, objectName, interfaceClass);
    }

    public <T> T newMXBeanProxy(ObjectName objectName, Class<T> interfaceClass, boolean notificationBroadcaster) {
        return JMX.newMXBeanProxy(this.configMBeanServer, objectName, interfaceClass, notificationBroadcaster);
    }

    public Set<ObjectName> getRegisteredObjectNames() {
        return Collections.unmodifiableSet(this.registeredObjectNames);
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        Set<ObjectName> result = this.configMBeanServer.queryNames(name, query);
        return this.getSameNames(result);
    }

    private Set<ObjectName> getSameNames(Set<ObjectName> superSet) {
        HashSet<ObjectName> result = new HashSet<ObjectName>(superSet);
        result.retainAll(this.registeredObjectNames);
        for (InternalJMXRegistrator child : this.children) {
            result.addAll(child.getSameNames(superSet));
        }
        return result;
    }

    static class InternalJMXRegistration
    implements AutoCloseable {
        private final InternalJMXRegistrator internalJMXRegistrator;
        private final ObjectName on;

        InternalJMXRegistration(InternalJMXRegistrator internalJMXRegistrator, ObjectName on) {
            this.internalJMXRegistrator = internalJMXRegistrator;
            this.on = on;
        }

        @Override
        public void close() {
            this.internalJMXRegistrator.unregisterMBean(this.on);
        }
    }
}

