/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.runtime.HierarchicalRuntimeBeanRegistration;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.manager.impl.jmx.InternalJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.RootRuntimeBeanRegistratorImpl;

public class HierarchicalRuntimeBeanRegistrationImpl
implements HierarchicalRuntimeBeanRegistration {
    private final ModuleIdentifier moduleIdentifier;
    private final InternalJMXRegistrator internalJMXRegistrator;
    private final Map<String, String> properties;

    public HierarchicalRuntimeBeanRegistrationImpl(ModuleIdentifier moduleIdentifier, InternalJMXRegistrator internalJMXRegistrator, Map<String, String> properties) {
        this.moduleIdentifier = moduleIdentifier;
        this.internalJMXRegistrator = internalJMXRegistrator;
        this.properties = properties;
    }

    public ObjectName getObjectName() {
        return ObjectNameUtil.createRuntimeBeanName((String)this.moduleIdentifier.getFactoryName(), (String)this.moduleIdentifier.getInstanceName(), this.properties);
    }

    public HierarchicalRuntimeBeanRegistrationImpl register(String key, String value, RuntimeBean mxBean) {
        HashMap<String, String> currentProperties = new HashMap<String, String>(this.properties);
        currentProperties.put(key, value);
        ObjectName on = ObjectNameUtil.createRuntimeBeanName((String)this.moduleIdentifier.getFactoryName(), (String)this.moduleIdentifier.getInstanceName(), currentProperties);
        InternalJMXRegistrator child = this.internalJMXRegistrator.createChild();
        try {
            child.registerMBean(mxBean, on);
        }
        catch (InstanceAlreadyExistsException e) {
            throw RootRuntimeBeanRegistratorImpl.sanitize(e, this.moduleIdentifier, on);
        }
        return new HierarchicalRuntimeBeanRegistrationImpl(this.moduleIdentifier, child, currentProperties);
    }

    public void close() {
        this.internalJMXRegistrator.close();
    }
}

