/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.factoriesresolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalConfigMBeanFactoriesHolder {
    private static final Logger logger = LoggerFactory.getLogger(HierarchicalConfigMBeanFactoriesHolder.class);
    private final Map<String, Map.Entry<ModuleFactory, BundleContext>> moduleNamesToConfigBeanFactories;
    private final Set<String> moduleNames;
    private final List<ModuleFactory> moduleFactories;

    public HierarchicalConfigMBeanFactoriesHolder(Map<String, Map.Entry<ModuleFactory, BundleContext>> factoriesMap) {
        this.moduleNamesToConfigBeanFactories = Collections.unmodifiableMap(factoriesMap);
        this.moduleNames = Collections.unmodifiableSet(new TreeSet<String>(this.moduleNamesToConfigBeanFactories.keySet()));
        ArrayList<ModuleFactory> factories = new ArrayList<ModuleFactory>(this.moduleNamesToConfigBeanFactories.size());
        Collection<Map.Entry<ModuleFactory, BundleContext>> entryCollection = this.moduleNamesToConfigBeanFactories.values();
        for (Map.Entry<ModuleFactory, BundleContext> entry : entryCollection) {
            factories.add(entry.getKey());
        }
        this.moduleFactories = Collections.unmodifiableList(factories);
    }

    public ModuleFactory findByModuleName(String moduleName) {
        Map.Entry<ModuleFactory, BundleContext> result = this.moduleNamesToConfigBeanFactories.get(moduleName);
        if (result == null) {
            throw new IllegalArgumentException("ModuleFactory not found with module name: " + moduleName);
        }
        return result.getKey();
    }

    public Set<String> getModuleNames() {
        return this.moduleNames;
    }

    public List<ModuleFactory> getModuleFactories() {
        return this.moduleFactories;
    }

    public Map<String, Map.Entry<ModuleFactory, BundleContext>> getModuleNamesToConfigBeanFactories() {
        return this.moduleNamesToConfigBeanFactories;
    }
}

