/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import java.lang.reflect.Method;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.TransactionIdentifier;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AbstractDynamicWrapper;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AttributeHolder;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.ReadOnlyAtomicBoolean;
import org.opendaylight.controller.config.spi.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DynamicWritableWrapper
extends AbstractDynamicWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DynamicWritableWrapper.class);
    private final ReadOnlyAtomicBoolean configBeanModificationDisabled;

    public DynamicWritableWrapper(Module module, ModuleIdentifier moduleIdentifier, TransactionIdentifier transactionIdentifier, ReadOnlyAtomicBoolean configBeanModificationDisabled, MBeanServer internalServer, MBeanServer configMBeanServer) {
        super(module, true, moduleIdentifier, ObjectNameUtil.createTransactionModuleON((String)transactionIdentifier.getName(), (ModuleIdentifier)moduleIdentifier), DynamicWritableWrapper.getOperations(moduleIdentifier), internalServer, configMBeanServer);
        this.configBeanModificationDisabled = configBeanModificationDisabled;
    }

    private static MBeanOperationInfo[] getOperations(ModuleIdentifier moduleIdentifier) {
        Method validationMethod;
        try {
            validationMethod = DynamicWritableWrapper.class.getMethod("validate", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method exception on " + moduleIdentifier, e);
        }
        return new MBeanOperationInfo[]{new MBeanOperationInfo("Validation", validationMethod)};
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.configBeanModificationDisabled.get()) {
            throw new IllegalStateException("Operation is not allowed now");
        }
        if (attribute.getName().equals("Attribute")) {
            this.setAttribute((Attribute)attribute.getValue());
            return;
        }
        try {
            if (attribute.getValue() instanceof ObjectName) {
                attribute = this.fixDependencyAttribute(attribute);
            } else if (attribute.getValue() instanceof ObjectName[]) {
                attribute = this.fixDependencyListAttribute(attribute);
            }
            this.internalServer.setAttribute(this.objectNameInternal, attribute);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
    }

    private Attribute fixDependencyListAttribute(Attribute attribute) {
        AttributeHolder attributeHolder = (AttributeHolder)this.attributeHolderMap.get(attribute.getName());
        if (attributeHolder.getRequireInterfaceOrNull() != null) {
            attribute = new Attribute(attribute.getName(), this.fixObjectNames((ObjectName[])attribute.getValue()));
        }
        return attribute;
    }

    private Attribute fixDependencyAttribute(Attribute attribute) {
        AttributeHolder attributeHolder = (AttributeHolder)this.attributeHolderMap.get(attribute.getName());
        attribute = attributeHolder.getRequireInterfaceOrNull() != null ? new Attribute(attribute.getName(), this.fixObjectName((ObjectName)attribute.getValue())) : new Attribute(attribute.getName(), attribute.getValue());
        return attribute;
    }

    private ObjectName[] fixObjectNames(ObjectName[] dependencies) {
        int i = 0;
        for (ObjectName dependencyOn : dependencies) {
            dependencies[i++] = this.fixObjectName(dependencyOn);
        }
        return dependencies;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList();
        for (Object attributeObject : attributes) {
            Attribute attribute = (Attribute)attributeObject;
            try {
                this.setAttribute(attribute);
                result.add(attribute);
            }
            catch (Exception e) {
                logger.warn("Setting attribute {} failed on {}", new Object[]{attribute.getName(), this.moduleIdentifier, e});
                throw new IllegalArgumentException("Setting attribute failed - " + attribute.getName() + " on " + this.moduleIdentifier, e);
            }
        }
        return result;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (!(!"validate".equals(actionName) || params != null && params.length != 0 || signature != null && signature.length != 0)) {
            try {
                this.validate();
            }
            catch (Exception e) {
                throw ValidationException.createForSingleException((ModuleIdentifier)this.moduleIdentifier, (Exception)e);
            }
            return Void.TYPE;
        }
        return super.invoke(actionName, params, signature);
    }

    public void validate() {
        this.module.validate();
    }
}

