/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AnnotationsHelper;

@Immutable
class AttributeHolder {
    private final String name;
    private final String description;
    private final Object object;
    private final boolean writable;
    @Nullable
    private final RequireInterface requireInterfaceAnnotation;
    private final String attributeType;
    public static final Set<Class<?>> PERMITTED_PARAMETER_TYPES_FOR_DEPENDENCY_SETTER = new HashSet();

    public AttributeHolder(String name, Object object, String returnType, boolean writable, @Nullable RequireInterface requireInterfaceAnnotation, String description) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        if (object == null) {
            throw new NullPointerException();
        }
        this.object = object;
        this.writable = writable;
        this.requireInterfaceAnnotation = requireInterfaceAnnotation;
        this.attributeType = returnType;
        this.description = description;
    }

    public MBeanAttributeInfo toMBeanAttributeInfo() {
        MBeanAttributeInfo info = new MBeanAttributeInfo(this.name, this.attributeType, this.description, true, true, false);
        return info;
    }

    RequireInterface getRequireInterfaceOrNull() {
        return this.requireInterfaceAnnotation;
    }

    public String getName() {
        return this.name;
    }

    public Object getObject() {
        return this.object;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public String getDescription() {
        return this.description;
    }

    static String findDescription(Method setter, Set<Class<?>> jmxInterfaces) {
        List<Description> descriptions = AnnotationsHelper.findMethodAnnotationInSuperClassesAndIfcs(setter, Description.class, jmxInterfaces);
        return AnnotationsHelper.aggregateDescriptions(descriptions);
    }

    static RequireInterface findRequireInterfaceAnnotation(Method setter, Set<Class<?>> inspectedInterfaces) {
        if (setter.getParameterTypes().length > 1) {
            return null;
        }
        if (!PERMITTED_PARAMETER_TYPES_FOR_DEPENDENCY_SETTER.contains(setter.getParameterTypes()[0])) {
            return null;
        }
        List<RequireInterface> foundRequireInterfaces = AnnotationsHelper.findMethodAnnotationInSuperClassesAndIfcs(setter, RequireInterface.class, inspectedInterfaces);
        HashSet<Class> foundValues = new HashSet<Class>();
        for (RequireInterface ri : foundRequireInterfaces) {
            foundValues.add(ri.value());
        }
        if (foundValues.size() == 0) {
            return null;
        }
        if (foundValues.size() > 1) {
            throw new IllegalStateException("Error finding @RequireInterface. More than one value specified as required interface " + foundValues + " of " + setter + " of " + setter.getDeclaringClass());
        }
        return foundRequireInterfaces.get(0);
    }

    static {
        PERMITTED_PARAMETER_TYPES_FOR_DEPENDENCY_SETTER.add(ObjectName.class);
        PERMITTED_PARAMETER_TYPES_FOR_DEPENDENCY_SETTER.add(ObjectName[].class);
        PERMITTED_PARAMETER_TYPES_FOR_DEPENDENCY_SETTER.add(List.class);
    }
}

