/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.config.api.annotations.Description;

class AnnotationsHelper {
    AnnotationsHelper() {
    }

    static <T extends Annotation> List<T> findMethodAnnotationInSuperClassesAndIfcs(Method setter, Class<T> annotationType, Set<Class<?>> inspectedInterfaces) {
        ArrayList<T> result = new ArrayList<T>();
        Class<Object> inspectedClass = setter.getDeclaringClass();
        do {
            try {
                Method foundSetter = inspectedClass.getMethod(setter.getName(), setter.getParameterTypes());
                T annotation = foundSetter.getAnnotation(annotationType);
                if (annotation != null) {
                    result.add(annotation);
                }
                inspectedClass = inspectedClass.getSuperclass();
            }
            catch (NoSuchMethodException e) {
                inspectedClass = Object.class;
            }
        } while (!inspectedClass.equals(Object.class));
        for (Class<?> ifc : inspectedInterfaces) {
            if (!ifc.isInterface()) {
                throw new IllegalArgumentException(ifc + " is not an interface");
            }
            try {
                Method foundSetter = ifc.getMethod(setter.getName(), setter.getParameterTypes());
                T annotation = foundSetter.getAnnotation(annotationType);
                if (annotation == null) continue;
                result.add(annotation);
            }
            catch (NoSuchMethodException e) {}
        }
        return result;
    }

    static <T extends Annotation> List<T> findClassAnnotationInSuperClassesAndIfcs(Class<?> clazz, Class<T> annotationType, Set<Class<?>> interfaces) {
        ArrayList<T> result = new ArrayList<T>();
        Class<?> declaringClass = clazz;
        do {
            T annotation;
            if ((annotation = declaringClass.getAnnotation(annotationType)) == null) continue;
            result.add(annotation);
        } while (!(declaringClass = declaringClass.getSuperclass()).equals(Object.class));
        for (Class<?> ifc : interfaces) {
            if (!ifc.isInterface()) {
                throw new IllegalArgumentException(ifc + " is not an interface");
            }
            T annotation = ifc.getAnnotation(annotationType);
            if (annotation == null) continue;
            result.add(annotation);
        }
        return result;
    }

    static String aggregateDescriptions(List<Description> descriptions) {
        StringBuilder builder = new StringBuilder();
        for (Description d : descriptions) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            builder.append(d.value());
        }
        return builder.toString();
    }
}

