/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AnnotationsHelper;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AttributeHolder;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.DynamicMBeanModuleWrapper;
import org.opendaylight.controller.config.manager.impl.util.InterfacesHelper;
import org.opendaylight.controller.config.spi.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDynamicWrapper
implements DynamicMBeanModuleWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDynamicWrapper.class);
    protected final boolean writable;
    protected final Module module;
    private final MBeanInfo mbeanInfo;
    protected final ObjectName objectNameInternal;
    protected final Map<String, AttributeHolder> attributeHolderMap;
    protected final ModuleIdentifier moduleIdentifier;
    protected final MBeanServer internalServer;

    public AbstractDynamicWrapper(Module module, boolean writable, ModuleIdentifier moduleIdentifier, ObjectName thisWrapperObjectName, MBeanOperationInfo[] dOperations, MBeanServer internalServer, MBeanServer configMBeanServer) {
        this.writable = writable;
        this.module = module;
        this.moduleIdentifier = moduleIdentifier;
        this.internalServer = internalServer;
        this.objectNameInternal = thisWrapperObjectName;
        this.registerActualModule(module, thisWrapperObjectName, this.objectNameInternal, internalServer, configMBeanServer);
        Set<Class<?>> jmxInterfaces = InterfacesHelper.getMXInterfaces(module.getClass());
        this.attributeHolderMap = AbstractDynamicWrapper.buildMBeanInfo(module, writable, moduleIdentifier, jmxInterfaces, internalServer, this.objectNameInternal);
        this.mbeanInfo = AbstractDynamicWrapper.generateMBeanInfo(module.getClass().getName(), module, this.attributeHolderMap, dOperations, jmxInterfaces);
    }

    private final NotificationListener registerActualModule(Module module, final ObjectName thisWrapperObjectName, final ObjectName objectNameInternal, final MBeanServer internalServer, final MBeanServer configMBeanServer) {
        try {
            internalServer.registerMBean(module, objectNameInternal);
        }
        catch (IllegalStateException | InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            throw new IllegalStateException("Error occured during mbean registration with name " + objectNameInternal, e);
        }
        NotificationListener listener = new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object handback) {
                if (n instanceof MBeanServerNotification && n.getType().equals("JMX.mbean.unregistered") && ((MBeanServerNotification)n).getMBeanName().equals(thisWrapperObjectName)) {
                    try {
                        internalServer.unregisterMBean(objectNameInternal);
                        configMBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
                    }
                    catch (InstanceNotFoundException | ListenerNotFoundException | MBeanRegistrationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        };
        try {
            configMBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, listener, null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException("Could not add notification listener", e);
        }
        return listener;
    }

    private static MBeanInfo generateMBeanInfo(String className, Module module, Map<String, AttributeHolder> attributeHolderMap, MBeanOperationInfo[] dOperations, Set<Class<?>> jmxInterfaces) {
        String dDescription = AbstractDynamicWrapper.findDescription(module.getClass(), jmxInterfaces);
        MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[]{};
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>(attributeHolderMap.size());
        for (AttributeHolder attributeHolder : attributeHolderMap.values()) {
            attributes.add(attributeHolder.toMBeanAttributeInfo());
        }
        return new MBeanInfo(className, dDescription, attributes.toArray(new MBeanAttributeInfo[0]), dConstructors, dOperations, new MBeanNotificationInfo[0]);
    }

    static String findDescription(Class<?> clazz, Set<Class<?>> jmxInterfaces) {
        List<Description> descriptions = AnnotationsHelper.findClassAnnotationInSuperClassesAndIfcs(clazz, Description.class, jmxInterfaces);
        return AnnotationsHelper.aggregateDescriptions(descriptions);
    }

    protected static MBeanOperationInfo[] getEmptyOperations() {
        return new MBeanOperationInfo[0];
    }

    private static Map<String, AttributeHolder> buildMBeanInfo(Module module, boolean writable, ModuleIdentifier moduleIdentifier, Set<Class<?>> jmxInterfaces, MBeanServer internalServer, ObjectName internalObjectName) {
        MBeanInfo internalInfo;
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> exportedClass : jmxInterfaces) {
            Method[] ifcMethods = exportedClass.getMethods();
            methods.addAll(Arrays.asList(ifcMethods));
        }
        try {
            internalInfo = internalServer.getMBeanInfo(internalObjectName);
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            throw new RuntimeException("MBean info not found", e);
        }
        HashMap<String, MBeanAttributeInfo> attributeMap = new HashMap<String, MBeanAttributeInfo>();
        for (MBeanAttributeInfo a : internalInfo.getAttributes()) {
            attributeMap.put(a.getName(), a);
        }
        HashMap<String, AttributeHolder> attributeHolderMap = new HashMap<String, AttributeHolder>();
        for (Method method : methods) {
            Method setter;
            if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
            String attribName = method.getName().substring(3);
            try {
                setter = module.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No such method on " + moduleIdentifier, e);
            }
            RequireInterface ifc = AttributeHolder.findRequireInterfaceAnnotation(setter, jmxInterfaces);
            String description = null;
            if (ifc != null) {
                description = AttributeHolder.findDescription(setter, jmxInterfaces);
            }
            AttributeHolder attributeHolder = new AttributeHolder(attribName, module, ((MBeanAttributeInfo)attributeMap.get(attribName)).getType(), writable, ifc, description);
            attributeHolderMap.put(attribName, attributeHolder);
        }
        return attributeHolderMap;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName.equals("MBeanInfo")) {
            return this.getMBeanInfo();
        }
        Object obj = null;
        try {
            obj = this.internalServer.getAttribute(this.objectNameInternal, attributeName);
        }
        catch (InstanceNotFoundException e) {
            new MBeanException(e);
        }
        if (obj instanceof ObjectName) {
            AttributeHolder attributeHolder = this.attributeHolderMap.get(attributeName);
            if (attributeHolder.getRequireInterfaceOrNull() != null) {
                obj = this.fixObjectName((ObjectName)obj);
            }
            return obj;
        }
        if (this.isDependencyListAttr(attributeName, obj)) {
            obj = this.fixDependencyListAttribute(obj);
        }
        return obj;
    }

    private Object fixDependencyListAttribute(Object attribute) {
        if (!attribute.getClass().isArray()) {
            throw new IllegalArgumentException("Unexpected attribute type, should be an array, but was " + attribute.getClass());
        }
        for (int i = 0; i < Array.getLength(attribute); ++i) {
            Object on = Array.get(attribute, i);
            if (!(on instanceof ObjectName)) {
                throw new IllegalArgumentException("Unexpected attribute type, should be an ObjectName, but was " + on.getClass());
            }
            on = this.fixObjectName((ObjectName)on);
            Array.set(attribute, i, on);
        }
        return attribute;
    }

    private boolean isDependencyListAttr(String attributeName, Object attribute) {
        if (!this.attributeHolderMap.containsKey(attributeName)) {
            return false;
        }
        AttributeHolder attributeHolder = this.attributeHolderMap.get(attributeName);
        boolean isDepList = true;
        isDepList &= attributeHolder.getRequireInterfaceOrNull() != null;
        return isDepList &= attribute instanceof ObjectName[];
    }

    protected ObjectName fixObjectName(ObjectName on) {
        if (!"org.opendaylight.controller".equals(on.getDomain())) {
            throw new IllegalArgumentException("Wrong domain, expected org.opendaylight.controller setter on " + on);
        }
        String transactionName = ObjectNameUtil.getTransactionName((ObjectName)on);
        if (transactionName != null) {
            return ObjectNameUtil.withoutTransactionName((ObjectName)on);
        }
        return on;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        for (String attributeName : attributes) {
            try {
                Object value = this.getAttribute(attributeName);
                result.add(new Attribute(attributeName, value));
            }
            catch (Exception e) {
                logger.debug("Getting attribute {} failed", (Object)attributeName, (Object)e);
            }
        }
        return result;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if ("getAttribute".equals(actionName) && params.length == 1 && signature[0].equals(String.class.getName())) {
            try {
                return this.getAttribute((String)params[0]);
            }
            catch (AttributeNotFoundException e) {
                throw new MBeanException(e, "Attribute not found on " + this.moduleIdentifier);
            }
        }
        if ("getAttributes".equals(actionName) && params.length == 1 && signature[0].equals(String[].class.getName())) {
            return this.getAttributes((String[])params[0]);
        }
        if ("setAttributes".equals(actionName) && params.length == 1 && signature[0].equals(AttributeList.class.getName())) {
            return this.setAttributes((AttributeList)params[0]);
        }
        logger.debug("Operation not found {} ", (Object)actionName);
        throw new UnsupportedOperationException(String.format("Operation not found on %s. Method invoke is only supported for getInstance and getAttribute(s) method, got actionName %s, params %s, signature %s ", this.moduleIdentifier, actionName, params, signature));
    }

    public final int hashCode() {
        return this.module.hashCode();
    }

    public final boolean equals(Object other) {
        return this.module.equals(other);
    }
}

