/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dependencyresolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.management.InstanceAlreadyExistsException;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.impl.CommitInfo;
import org.opendaylight.controller.config.manager.impl.DestroyedModule;
import org.opendaylight.controller.config.manager.impl.ModuleInternalTransactionalInfo;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.TransactionHolder;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;

class ModulesHolder
implements TransactionHolder {
    private final String transactionName;
    @GuardedBy(value="this")
    private final Map<ModuleIdentifier, ModuleInternalTransactionalInfo> commitMap = new HashMap<ModuleIdentifier, ModuleInternalTransactionalInfo>();
    @GuardedBy(value="this")
    private final Set<ModuleInternalTransactionalInfo> unorderedDestroyedFromPreviousTransactions = new HashSet<ModuleInternalTransactionalInfo>();

    ModulesHolder(String transactionName) {
        this.transactionName = transactionName;
    }

    @Override
    public CommitInfo toCommitInfo() {
        ArrayList<DestroyedModule> orderedDestroyedFromPreviousTransactions = new ArrayList<DestroyedModule>(this.unorderedDestroyedFromPreviousTransactions.size());
        for (ModuleInternalTransactionalInfo toBeDestroyed : this.unorderedDestroyedFromPreviousTransactions) {
            orderedDestroyedFromPreviousTransactions.add(toBeDestroyed.toDestroyedModule());
        }
        Collections.sort(orderedDestroyedFromPreviousTransactions);
        return new CommitInfo(orderedDestroyedFromPreviousTransactions, this.commitMap);
    }

    private ModuleInternalTransactionalInfo findModuleInternalTransactionalInfo(ModuleIdentifier moduleIdentifier, JmxAttribute jmxAttributeForReporting) {
        ModuleInternalTransactionalInfo moduleInternalTransactionalInfo = this.commitMap.get(moduleIdentifier);
        JmxAttributeValidationException.checkNotNull((Object)moduleInternalTransactionalInfo, (String)("Module " + moduleIdentifier + "" + " not found in transaction " + this.transactionName), (JmxAttribute)jmxAttributeForReporting);
        return moduleInternalTransactionalInfo;
    }

    @Override
    public Module findModule(ModuleIdentifier moduleIdentifier, JmxAttribute jmxAttributeForReporting) {
        return this.findModuleInternalTransactionalInfo(moduleIdentifier, jmxAttributeForReporting).getModule();
    }

    @Override
    public ModuleFactory findModuleFactory(ModuleIdentifier moduleIdentifier, JmxAttribute jmxAttributeForReporting) {
        return this.findModuleInternalTransactionalInfo(moduleIdentifier, jmxAttributeForReporting).getModuleFactory();
    }

    @Override
    public Map<ModuleIdentifier, Module> getAllModules() {
        HashMap<ModuleIdentifier, Module> result = new HashMap<ModuleIdentifier, Module>();
        for (ModuleInternalTransactionalInfo entry : this.commitMap.values()) {
            ModuleIdentifier name = entry.getIdentifier();
            result.put(name, entry.getModule());
        }
        return result;
    }

    @Override
    public void put(ModuleInternalTransactionalInfo moduleInternalTransactionalInfo) {
        this.commitMap.put(moduleInternalTransactionalInfo.getIdentifier(), moduleInternalTransactionalInfo);
    }

    @Override
    public ModuleInternalTransactionalInfo destroyModule(ModuleIdentifier moduleIdentifier) {
        ModuleInternalTransactionalInfo found = this.commitMap.remove(moduleIdentifier);
        if (found == null) {
            throw new IllegalStateException("Not found:" + moduleIdentifier);
        }
        if (found.hasOldModule()) {
            this.unorderedDestroyedFromPreviousTransactions.add(found);
        }
        return found;
    }

    @Override
    public void assertNotExists(ModuleIdentifier moduleIdentifier) throws InstanceAlreadyExistsException {
        if (this.commitMap.containsKey(moduleIdentifier)) {
            throw new InstanceAlreadyExistsException("There is an instance registered with name " + moduleIdentifier);
        }
    }

    public Collection<ModuleInternalTransactionalInfo> getAllInfos() {
        return this.commitMap.values();
    }

    @Override
    public ModuleInternalTransactionalInfo findModuleInternalTransactionalInfo(ModuleIdentifier moduleIdentifier) {
        ModuleInternalTransactionalInfo found = this.commitMap.get(moduleIdentifier);
        if (found == null) {
            throw new IllegalStateException("Not found:" + moduleIdentifier);
        }
        return found;
    }
}

