/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dependencyresolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.management.InstanceAlreadyExistsException;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.manager.impl.CommitInfo;
import org.opendaylight.controller.config.manager.impl.ModuleInternalTransactionalInfo;
import org.opendaylight.controller.config.manager.impl.TransactionStatus;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.DependencyResolverImpl;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.ModulesHolder;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.TransactionHolder;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;

public class DependencyResolverManager
implements TransactionHolder,
DependencyResolverFactory {
    @GuardedBy(value="this")
    private final Map<ModuleIdentifier, DependencyResolverImpl> moduleIdentifiersToDependencyResolverMap = new HashMap<ModuleIdentifier, DependencyResolverImpl>();
    private final ModulesHolder modulesHolder;
    private final TransactionStatus transactionStatus;
    private final ServiceReferenceReadableRegistry readableRegistry;
    private final CodecRegistry codecRegistry;

    public DependencyResolverManager(String transactionName, TransactionStatus transactionStatus, ServiceReferenceReadableRegistry readableRegistry, CodecRegistry codecRegistry) {
        this.modulesHolder = new ModulesHolder(transactionName);
        this.transactionStatus = transactionStatus;
        this.readableRegistry = readableRegistry;
        this.codecRegistry = codecRegistry;
    }

    public DependencyResolver createDependencyResolver(ModuleIdentifier moduleIdentifier) {
        return this.getOrCreate(moduleIdentifier);
    }

    public synchronized DependencyResolverImpl getOrCreate(ModuleIdentifier name) {
        DependencyResolverImpl dependencyResolver = this.moduleIdentifiersToDependencyResolverMap.get(name);
        if (dependencyResolver == null) {
            this.transactionStatus.checkNotCommitted();
            dependencyResolver = new DependencyResolverImpl(name, this.transactionStatus, this.modulesHolder, this.readableRegistry, this.codecRegistry);
            this.moduleIdentifiersToDependencyResolverMap.put(name, dependencyResolver);
        }
        return dependencyResolver;
    }

    private List<DependencyResolverImpl> getAllSorted() {
        this.transactionStatus.checkCommitted();
        ArrayList<DependencyResolverImpl> sorted = new ArrayList<DependencyResolverImpl>(this.moduleIdentifiersToDependencyResolverMap.values());
        for (DependencyResolverImpl dri : sorted) {
            dri.countMaxDependencyDepth(this);
        }
        Collections.sort(sorted);
        return sorted;
    }

    public List<ModuleIdentifier> getSortedModuleIdentifiers() {
        ArrayList<ModuleIdentifier> result = new ArrayList<ModuleIdentifier>(this.moduleIdentifiersToDependencyResolverMap.size());
        for (DependencyResolverImpl dri : this.getAllSorted()) {
            ModuleIdentifier driName = dri.getIdentifier();
            result.add(driName);
        }
        return result;
    }

    @Override
    public ModuleInternalTransactionalInfo destroyModule(ModuleIdentifier moduleIdentifier) {
        this.transactionStatus.checkNotCommitted();
        ModuleInternalTransactionalInfo found = this.modulesHolder.destroyModule(moduleIdentifier);
        this.moduleIdentifiersToDependencyResolverMap.remove(moduleIdentifier);
        return found;
    }

    @Override
    public void put(ModuleInternalTransactionalInfo moduleInternalTransactionalInfo) {
        this.transactionStatus.checkNotCommitted();
        this.modulesHolder.put(moduleInternalTransactionalInfo);
    }

    @Override
    public CommitInfo toCommitInfo() {
        return this.modulesHolder.toCommitInfo();
    }

    @Override
    public Module findModule(ModuleIdentifier moduleIdentifier, JmxAttribute jmxAttributeForReporting) {
        return this.modulesHolder.findModule(moduleIdentifier, jmxAttributeForReporting);
    }

    @Override
    public ModuleInternalTransactionalInfo findModuleInternalTransactionalInfo(ModuleIdentifier moduleIdentifier) {
        return this.modulesHolder.findModuleInternalTransactionalInfo(moduleIdentifier);
    }

    @Override
    public ModuleFactory findModuleFactory(ModuleIdentifier moduleIdentifier, JmxAttribute jmxAttributeForReporting) {
        return this.modulesHolder.findModuleFactory(moduleIdentifier, jmxAttributeForReporting);
    }

    @Override
    public Map<ModuleIdentifier, Module> getAllModules() {
        return this.modulesHolder.getAllModules();
    }

    @Override
    public void assertNotExists(ModuleIdentifier moduleIdentifier) throws InstanceAlreadyExistsException {
        this.modulesHolder.assertNotExists(moduleIdentifier);
    }

    public List<ModuleIdentifier> findAllByFactory(ModuleFactory factory) {
        ArrayList<ModuleIdentifier> result = new ArrayList<ModuleIdentifier>();
        for (ModuleInternalTransactionalInfo info : this.modulesHolder.getAllInfos()) {
            if (!factory.equals(info.getModuleFactory())) continue;
            result.add(info.getIdentifier());
        }
        return result;
    }
}

