/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dependencyresolver;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.IdentityAttributeRef;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.TransactionStatus;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.DependencyResolverManager;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.ModulesHolder;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.opendaylight.yangtools.yang.data.impl.codec.IdentityCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DependencyResolverImpl
implements DependencyResolver,
Comparable<DependencyResolverImpl> {
    private static final Logger logger = LoggerFactory.getLogger(DependencyResolverImpl.class);
    private final ModulesHolder modulesHolder;
    private final ModuleIdentifier name;
    private final TransactionStatus transactionStatus;
    @GuardedBy(value="this")
    private final Set<ModuleIdentifier> dependencies = new HashSet<ModuleIdentifier>();
    private final ServiceReferenceReadableRegistry readableRegistry;
    private final CodecRegistry codecRegistry;
    private Integer maxDependencyDepth;

    DependencyResolverImpl(ModuleIdentifier currentModule, TransactionStatus transactionStatus, ModulesHolder modulesHolder, ServiceReferenceReadableRegistry readableRegistry, CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
        this.name = currentModule;
        this.transactionStatus = transactionStatus;
        this.modulesHolder = modulesHolder;
        this.readableRegistry = readableRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDependency(Class<? extends AbstractServiceInterface> expectedServiceInterface, ObjectName dependentReadOnlyON, JmxAttribute jmxAttribute) {
        this.transactionStatus.checkNotCommitted();
        if (expectedServiceInterface == null) {
            throw new NullPointerException("Parameter 'expectedServiceInterface' is null");
        }
        if (jmxAttribute == null) {
            throw new NullPointerException("Parameter 'jmxAttribute' is null");
        }
        JmxAttributeValidationException.checkNotNull((Object)dependentReadOnlyON, (String)("is null, expected dependency implementing " + expectedServiceInterface), (JmxAttribute)jmxAttribute);
        boolean hasTransaction = ObjectNameUtil.getTransactionName((ObjectName)dependentReadOnlyON) != null;
        JmxAttributeValidationException.checkCondition((!hasTransaction ? 1 : 0) != 0, (String)String.format("ObjectName should not contain transaction name. %s set to %s. ", jmxAttribute, dependentReadOnlyON), (JmxAttribute)jmxAttribute);
        dependentReadOnlyON = this.translateServiceRefIfPossible(dependentReadOnlyON);
        ModuleIdentifier moduleIdentifier = ObjectNameUtil.fromON((ObjectName)dependentReadOnlyON, (String)"Module");
        ModuleFactory foundFactory = this.modulesHolder.findModuleFactory(moduleIdentifier, jmxAttribute);
        boolean implementsSI = foundFactory.isModuleImplementingServiceInterface(expectedServiceInterface);
        if (!implementsSI) {
            String message = String.format("Found module factory does not expose expected service interface. Module name is %s : %s, expected service interface %s, dependent module ON %s , attribute %s", foundFactory.getImplementationName(), foundFactory, expectedServiceInterface, dependentReadOnlyON, jmxAttribute);
            throw new JmxAttributeValidationException(message, jmxAttribute);
        }
        DependencyResolverImpl dependencyResolverImpl = this;
        synchronized (dependencyResolverImpl) {
            this.dependencies.add(moduleIdentifier);
        }
    }

    private ObjectName translateServiceRefIfPossible(ObjectName dependentReadOnlyON) {
        if (ObjectNameUtil.isServiceReference((ObjectName)dependentReadOnlyON)) {
            String serviceQName = ObjectNameUtil.getServiceQName((ObjectName)dependentReadOnlyON);
            String refName = ObjectNameUtil.getReferenceName((ObjectName)dependentReadOnlyON);
            dependentReadOnlyON = ObjectNameUtil.withoutTransactionName((ObjectName)this.readableRegistry.lookupConfigBeanByServiceInterfaceName(serviceQName, refName));
        }
        return dependentReadOnlyON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T resolveInstance(Class<T> expectedType, ObjectName dependentReadOnlyON, JmxAttribute jmxAttribute) {
        if (expectedType == null || dependentReadOnlyON == null || jmxAttribute == null) {
            throw new IllegalArgumentException(String.format("Null parameters not allowed, got %s %s %s", expectedType, dependentReadOnlyON, jmxAttribute));
        }
        dependentReadOnlyON = this.translateServiceRefIfPossible(dependentReadOnlyON);
        this.transactionStatus.checkCommitStarted();
        this.transactionStatus.checkNotCommitted();
        ModuleIdentifier dependentModuleIdentifier = ObjectNameUtil.fromON((ObjectName)dependentReadOnlyON, (String)"Module");
        Module module = this.modulesHolder.findModule(dependentModuleIdentifier, jmxAttribute);
        DependencyResolverImpl dependencyResolverImpl = this;
        synchronized (dependencyResolverImpl) {
            this.dependencies.add(dependentModuleIdentifier);
        }
        AutoCloseable instance = module.getInstance();
        if (instance == null) {
            String message = String.format("Error while %s resolving instance %s. getInstance() returned null. Expected type %s , attribute %s", this.name, dependentModuleIdentifier, expectedType, jmxAttribute);
            throw new JmxAttributeValidationException(message, jmxAttribute);
        }
        try {
            T result = expectedType.cast(instance);
            return result;
        }
        catch (ClassCastException e) {
            String message = String.format("Instance cannot be cast to expected type. Instance class is %s , expected type %s , attribute %s", instance.getClass(), expectedType, jmxAttribute);
            throw new JmxAttributeValidationException(message, (Throwable)e, jmxAttribute);
        }
    }

    public <T extends BaseIdentity> Class<? extends T> resolveIdentity(IdentityAttributeRef identityRef, Class<T> expectedBaseClass) {
        QName qName = QName.create((String)identityRef.getqNameOfIdentity());
        IdentityCodec identityCodec = this.codecRegistry.getIdentityCodec();
        Class deserialized = identityCodec.deserialize(qName);
        if (deserialized == null) {
            throw new RuntimeException("Unable to retrieve identity class for " + qName + ", null response from " + this.codecRegistry);
        }
        if (expectedBaseClass.isAssignableFrom(deserialized)) {
            return deserialized;
        }
        logger.error("Cannot resolve class of identity {} : deserialized class {} is not a subclass of {}.", new Object[]{identityRef, deserialized, expectedBaseClass});
        throw new IllegalArgumentException("Deserialized identity " + deserialized + " cannot be cast to " + expectedBaseClass);
    }

    public <T extends BaseIdentity> void validateIdentity(IdentityAttributeRef identityRef, Class<T> expectedBaseClass, JmxAttribute jmxAttribute) {
        try {
            this.resolveIdentity(identityRef, expectedBaseClass);
        }
        catch (Exception e) {
            throw JmxAttributeValidationException.wrap((Throwable)e, (JmxAttribute)jmxAttribute);
        }
    }

    @Override
    public int compareTo(DependencyResolverImpl o) {
        this.transactionStatus.checkCommitted();
        return Integer.compare(this.getMaxDependencyDepth(), o.getMaxDependencyDepth());
    }

    int getMaxDependencyDepth() {
        if (this.maxDependencyDepth == null) {
            throw new IllegalStateException("Dependency depth was not computed");
        }
        return this.maxDependencyDepth;
    }

    public void countMaxDependencyDepth(DependencyResolverManager manager) {
        this.transactionStatus.checkCommitted();
        if (this.maxDependencyDepth == null) {
            this.maxDependencyDepth = DependencyResolverImpl.getMaxDepth(this, manager, new LinkedHashSet<ModuleIdentifier>());
        }
    }

    private static int getMaxDepth(DependencyResolverImpl impl, DependencyResolverManager manager, LinkedHashSet<ModuleIdentifier> chainForDetectingCycles) {
        int maxDepth = 0;
        LinkedHashSet<ModuleIdentifier> chainForDetectingCycles2 = new LinkedHashSet<ModuleIdentifier>(chainForDetectingCycles);
        chainForDetectingCycles2.add(impl.getIdentifier());
        for (ModuleIdentifier dependencyName : impl.dependencies) {
            int subDepth;
            DependencyResolverImpl dependentDRI = manager.getOrCreate(dependencyName);
            if (chainForDetectingCycles2.contains(dependencyName)) {
                throw new IllegalStateException(String.format("Cycle detected, %s contains %s", chainForDetectingCycles2, dependencyName));
            }
            if (dependentDRI.maxDependencyDepth != null) {
                subDepth = dependentDRI.maxDependencyDepth;
            } else {
                subDepth = DependencyResolverImpl.getMaxDepth(dependentDRI, manager, chainForDetectingCycles2);
                dependentDRI.maxDependencyDepth = subDepth;
            }
            if (subDepth + 1 <= maxDepth) continue;
            maxDepth = subDepth + 1;
        }
        impl.maxDependencyDepth = maxDepth;
        return maxDepth;
    }

    public ModuleIdentifier getIdentifier() {
        return this.name;
    }
}

